/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.jetty.server;

import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.impl.jetty.server.JettyServerHandler;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer
extends Server {
    private Thread thread;

    @Override
    public void start(final XxlRpcProviderFactory xxlRpcProviderFactory) throws Exception {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server((ThreadPool)new QueuedThreadPool());
                ServerConnector connector = new ServerConnector(server);
                connector.setPort(xxlRpcProviderFactory.getPort());
                server.setConnectors(new Connector[]{connector});
                HandlerCollection handlerc = new HandlerCollection();
                handlerc.setHandlers(new Handler[]{new JettyServerHandler(xxlRpcProviderFactory)});
                server.setHandler((Handler)handlerc);
                try {
                    server.start();
                    logger.info(">>>>>>>>>>> xxl-rpc remoting server start success, nettype = {}, port = {}", (Object)JettyServer.class.getName(), (Object)xxlRpcProviderFactory.getPort());
                    JettyServer.this.onStarted();
                    server.join();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        logger.info(">>>>>>>>>>> xxl-rpc remoting server stop.");
                    } else {
                        logger.error(">>>>>>>>>>> xxl-rpc remoting server error.", (Throwable)e);
                    }
                }
                finally {
                    if (server != null && server.isRunning()) {
                        try {
                            server.stop();
                            server.destroy();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.onStoped();
        logger.info(">>>>>>>>>>> xxl-rpc remoting server destroy success.");
    }
}

