/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.route.impl;

import com.xxl.rpc.remoting.invoker.route.XxlRpcLoadBalance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class XxlRpcLoadBalanceLFUStrategy
extends XxlRpcLoadBalance {
    private ConcurrentHashMap<String, HashMap<String, Integer>> jobLfuMap = new ConcurrentHashMap();
    private long CACHE_VALID_TIME = 0L;

    public String doRoute(String serviceKey, TreeSet<String> addressSet) {
        HashMap<String, Integer> lfuItemMap;
        if (System.currentTimeMillis() > this.CACHE_VALID_TIME) {
            this.jobLfuMap.clear();
            this.CACHE_VALID_TIME = System.currentTimeMillis() + 86400000L;
        }
        if ((lfuItemMap = this.jobLfuMap.get(serviceKey)) == null) {
            lfuItemMap = new HashMap();
            this.jobLfuMap.putIfAbsent(serviceKey, lfuItemMap);
        }
        for (String address : addressSet) {
            if (lfuItemMap.containsKey(address) && lfuItemMap.get(address) <= 1000000) continue;
            lfuItemMap.put(address, 0);
        }
        ArrayList<String> delKeys = new ArrayList<String>();
        for (String existKey : lfuItemMap.keySet()) {
            if (addressSet.contains(existKey)) continue;
            delKeys.add(existKey);
        }
        if (delKeys.size() > 0) {
            for (String delKey : delKeys) {
                lfuItemMap.remove(delKey);
            }
        }
        ArrayList<Map.Entry<String, Integer>> lfuItemList = new ArrayList<Map.Entry<String, Integer>>(lfuItemMap.entrySet());
        Collections.sort(lfuItemList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        Map.Entry addressItem = (Map.Entry)lfuItemList.get(0);
        String minAddress = (String)addressItem.getKey();
        addressItem.setValue((Integer)addressItem.getValue() + 1);
        return minAddress;
    }

    @Override
    public String route(String serviceKey, TreeSet<String> addressSet) {
        String finalAddress = this.doRoute(serviceKey, addressSet);
        return finalAddress;
    }
}

