/*
 * Decompiled with CFR 0.152.
 */
package com.youview.tinydnssd;

import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.youview.tinydnssd.MDNSDiscover;
import com.youview.tinydnssd.MapDebouncer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiscoverResolver {
    private static final String TAG = DiscoverResolver.class.getSimpleName();
    private static final int RESOLVE_TIMEOUT = 1000;
    private final MapDebouncer<String, Object> mDebouncer;
    private final Context mContext;
    private final String mServiceType;
    private final HashMap<String, MDNSDiscover.Result> mServices = new HashMap();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Listener mListener;
    private boolean mStarted;
    private boolean mTransitioning;
    private ResolveTask mResolveTask;
    private final Map<String, NsdServiceInfo> mResolveQueue = new LinkedHashMap<String, NsdServiceInfo>();
    private NsdManager.DiscoveryListener mDiscoveryListener = new NsdManager.DiscoveryListener(){

        public void onStartDiscoveryFailed(String serviceType, int errorCode) {
            Log.d((String)TAG, (String)("onStartDiscoveryFailed() serviceType = [" + serviceType + "], errorCode = [" + errorCode + "]"));
        }

        public void onStopDiscoveryFailed(String serviceType, int errorCode) {
            Log.d((String)TAG, (String)("onStopDiscoveryFailed() serviceType = [" + serviceType + "], errorCode = [" + errorCode + "]"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDiscoveryStarted(String serviceType) {
            Log.d((String)TAG, (String)("onDiscoveryStarted() serviceType = [" + serviceType + "]"));
            DiscoverResolver discoverResolver = DiscoverResolver.this;
            synchronized (discoverResolver) {
                if (!DiscoverResolver.this.mStarted) {
                    DiscoverResolver.this.stopServiceDiscovery(this);
                } else {
                    DiscoverResolver.this.mTransitioning = false;
                }
            }
        }

        public void onDiscoveryStopped(String serviceType) {
            Log.d((String)TAG, (String)("onDiscoveryStopped() serviceType = [" + serviceType + "]"));
            if (DiscoverResolver.this.mStarted) {
                DiscoverResolver.this.discoverServices(serviceType, 1, this);
            } else {
                DiscoverResolver.this.mTransitioning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceFound(NsdServiceInfo serviceInfo) {
            Log.d((String)TAG, (String)("onServiceFound() serviceInfo = [" + serviceInfo + "]"));
            DiscoverResolver discoverResolver = DiscoverResolver.this;
            synchronized (discoverResolver) {
                if (DiscoverResolver.this.mStarted) {
                    String name = serviceInfo.getServiceName() + "." + serviceInfo.getServiceType() + "local";
                    DiscoverResolver.this.mDebouncer.put(name, DiscoverResolver.this.DUMMY);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceLost(NsdServiceInfo serviceInfo) {
            Log.d((String)TAG, (String)("onServiceLost() serviceInfo = [" + serviceInfo + "]"));
            DiscoverResolver discoverResolver = DiscoverResolver.this;
            synchronized (discoverResolver) {
                if (DiscoverResolver.this.mStarted) {
                    String name = serviceInfo.getServiceName() + "." + serviceInfo.getServiceType() + "local";
                    DiscoverResolver.this.mDebouncer.put(name, null);
                }
            }
        }
    };
    private Object DUMMY = new Object();
    private boolean mServicesChanged;
    private Runnable mServicesChangedRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiscoverResolver discoverResolver = DiscoverResolver.this;
            synchronized (discoverResolver) {
                if (DiscoverResolver.this.mStarted && DiscoverResolver.this.mServicesChanged) {
                    Map services = (Map)DiscoverResolver.this.mServices.clone();
                    DiscoverResolver.this.mListener.onServicesChanged(services);
                }
                DiscoverResolver.this.mServicesChanged = false;
            }
        }
    };

    public DiscoverResolver(Context context, String serviceType, Listener listener) {
        this(context, serviceType, listener, 0);
    }

    public DiscoverResolver(Context context, String serviceType, Listener listener, int debounceMillis) {
        if (context == null) {
            throw new NullPointerException("context was null");
        }
        if (serviceType == null) {
            throw new NullPointerException("serviceType was null");
        }
        if (listener == null) {
            throw new NullPointerException("listener was null");
        }
        this.mContext = context;
        this.mServiceType = serviceType;
        this.mListener = listener;
        this.mDebouncer = new MapDebouncer<String, Object>(debounceMillis, new MapDebouncer.Listener<String, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(String name, Object o) {
                if (o != null) {
                    Log.d((String)TAG, (String)("add: " + name));
                    Map map = DiscoverResolver.this.mResolveQueue;
                    synchronized (map) {
                        DiscoverResolver.this.mResolveQueue.put(name, null);
                    }
                    DiscoverResolver.this.startResolveTaskIfNeeded();
                } else {
                    Log.d((String)TAG, (String)("remove: " + name));
                    DiscoverResolver discoverResolver = DiscoverResolver.this;
                    synchronized (discoverResolver) {
                        Map map = DiscoverResolver.this.mResolveQueue;
                        synchronized (map) {
                            DiscoverResolver.this.mResolveQueue.remove(name);
                        }
                        if (DiscoverResolver.this.mStarted && DiscoverResolver.this.mServices.remove(name) != null) {
                            DiscoverResolver.this.dispatchServicesChanged();
                        }
                    }
                }
            }
        });
    }

    public synchronized void start() {
        if (this.mStarted) {
            throw new IllegalStateException();
        }
        if (!this.mTransitioning) {
            this.discoverServices(this.mServiceType, 1, this.mDiscoveryListener);
            this.mTransitioning = true;
        }
        this.mStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.mStarted) {
            throw new IllegalStateException();
        }
        if (!this.mTransitioning) {
            this.stopServiceDiscovery(this.mDiscoveryListener);
            this.mTransitioning = true;
        }
        Map<String, NsdServiceInfo> map = this.mResolveQueue;
        synchronized (map) {
            this.mResolveQueue.clear();
        }
        this.mDebouncer.clear();
        this.mServices.clear();
        this.mServicesChanged = false;
        this.mStarted = false;
    }

    private void dispatchServicesChanged() {
        if (!this.mStarted) {
            throw new IllegalStateException();
        }
        if (!this.mServicesChanged) {
            this.mServicesChanged = true;
            this.mHandler.post(this.mServicesChangedRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResolveTaskIfNeeded() {
        if (this.mResolveTask == null) {
            Map<String, NsdServiceInfo> map = this.mResolveQueue;
            synchronized (map) {
                if (!this.mResolveQueue.isEmpty()) {
                    this.mResolveTask = new ResolveTask();
                    this.mResolveTask.execute(new Void[0]);
                }
            }
        }
    }

    protected void discoverServices(String serviceType, int protocol, NsdManager.DiscoveryListener listener) {
        ((NsdManager)this.mContext.getSystemService("servicediscovery")).discoverServices(serviceType, protocol, listener);
    }

    protected void stopServiceDiscovery(NsdManager.DiscoveryListener listener) {
        ((NsdManager)this.mContext.getSystemService("servicediscovery")).stopServiceDiscovery(listener);
    }

    protected MDNSDiscover.Result resolve(String serviceName, int resolveTimeout) throws IOException {
        return MDNSDiscover.resolve(serviceName, resolveTimeout);
    }

    private class ResolveTask
    extends AsyncTask<Void, Void, Void> {
        private ResolveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... params) {
            while (!this.isCancelled()) {
                String serviceName;
                Map map = DiscoverResolver.this.mResolveQueue;
                synchronized (map) {
                    Iterator it = DiscoverResolver.this.mResolveQueue.keySet().iterator();
                    if (!it.hasNext()) {
                        break;
                    }
                    serviceName = (String)it.next();
                    it.remove();
                }
                try {
                    MDNSDiscover.Result result = DiscoverResolver.this.resolve(serviceName, 1000);
                    DiscoverResolver discoverResolver = DiscoverResolver.this;
                    synchronized (discoverResolver) {
                        if (DiscoverResolver.this.mStarted) {
                            DiscoverResolver.this.mServices.put(serviceName, result);
                            DiscoverResolver.this.dispatchServicesChanged();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            DiscoverResolver.this.mResolveTask = null;
            DiscoverResolver.this.startResolveTaskIfNeeded();
        }
    }

    public static interface Listener {
        public void onServicesChanged(Map<String, MDNSDiscover.Result> var1);
    }
}

