/*
 * Decompiled with CFR 0.152.
 */
package com.youview.tinydnssd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;

public class MDNSDiscover {
    private static final short QTYPE_A = 1;
    static final short QTYPE_PTR = 12;
    static final short QTYPE_TXT = 16;
    static final short QTYPE_SRV = 33;
    static final short QCLASS_INTERNET = 1;
    static final short CLASS_FLAG_MULTICAST = 0;
    static final short CLASS_FLAG_UNICAST = Short.MIN_VALUE;
    private static final int PORT = 5353;
    private static final String MULTICAST_GROUP_ADDRESS = "224.0.0.251";
    private static final boolean DEBUG = false;

    private static byte[] discoverPacket(String serviceType) throws IOException {
        return MDNSDiscover.queryPacket(serviceType, -32767, 12);
    }

    static byte[] queryPacket(String serviceName, int qclass, int ... qtypes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(0);
        dos.writeShort(qtypes.length);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        int fqdnPtr = -1;
        for (int qtype : qtypes) {
            if (fqdnPtr == -1) {
                fqdnPtr = dos.size();
                MDNSDiscover.writeFQDN(serviceName, dos);
            } else {
                dos.write(0xC0 | fqdnPtr >> 8);
                dos.write(fqdnPtr & 0xFF);
            }
            dos.writeShort(qtype);
            dos.writeShort(qclass);
        }
        dos.close();
        return bos.toByteArray();
    }

    public static void discover(String serviceType, Callback callback, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        InetAddress group = InetAddress.getByName(MULTICAST_GROUP_ADDRESS);
        MulticastSocket sock = new MulticastSocket();
        byte[] data = MDNSDiscover.discoverPacket(serviceType);
        DatagramPacket packet = new DatagramPacket(data, data.length, group, 5353);
        sock.setTimeToLive(255);
        sock.send(packet);
        byte[] buf = new byte[1024];
        packet = new DatagramPacket(buf, buf.length);
        long endTime = 0L;
        if (timeout != 0) {
            endTime = System.currentTimeMillis() + (long)timeout;
        }
        while (true) {
            if (timeout != 0) {
                int remaining = (int)(endTime - System.currentTimeMillis());
                if (remaining <= 0) break;
                sock.setSoTimeout(remaining);
            }
            try {
                sock.receive(packet);
            }
            catch (SocketTimeoutException e) {
                break;
            }
            Result result = MDNSDiscover.decode(packet.getData(), packet.getLength());
            if (callback == null) continue;
            callback.onResult(result);
        }
    }

    public static Result resolve(String serviceName, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        InetAddress group = InetAddress.getByName(MULTICAST_GROUP_ADDRESS);
        MulticastSocket sock = new MulticastSocket();
        byte[] data = MDNSDiscover.queryPacket(serviceName, -32767, 1, 33, 16);
        DatagramPacket packet = new DatagramPacket(data, data.length, group, 5353);
        sock.setTimeToLive(255);
        sock.send(packet);
        byte[] buf = new byte[1024];
        packet = new DatagramPacket(buf, buf.length);
        Result result = new Result();
        long endTime = 0L;
        if (timeout != 0) {
            endTime = System.currentTimeMillis() + (long)timeout;
        }
        while (result.a == null || result.srv == null || result.txt == null) {
            if (timeout != 0) {
                int remaining = (int)(endTime - System.currentTimeMillis());
                if (remaining <= 0) break;
                sock.setSoTimeout(remaining);
            }
            sock.receive(packet);
            MDNSDiscover.decode(packet.getData(), packet.getLength(), result);
        }
        return result;
    }

    private static void writeFQDN(String name, OutputStream out) throws IOException {
        for (String part : name.split("\\.")) {
            out.write(part.length());
            out.write(part.getBytes());
        }
        out.write(0);
    }

    private static void hexdump(byte[] data, int offset, int length) {
        while (offset < length) {
            int col;
            System.out.printf("%08x", offset);
            int origOffset = offset;
            for (col = 0; col < 16 && offset < length; ++col, ++offset) {
                System.out.printf(" %02x", data[offset] & 0xFF);
            }
            while (col < 16) {
                System.out.printf("   ", new Object[0]);
                ++col;
            }
            System.out.print(" ");
            offset = origOffset;
            for (col = 0; col < 16 && offset < length; ++col, ++offset) {
                byte val = data[offset];
                char c = val >= 32 && val < 127 ? (char)((char)val) : (char)'.';
                System.out.printf("%c", Character.valueOf(c));
            }
            System.out.println();
        }
    }

    static Result decode(byte[] packet, int packetLength) throws IOException {
        Result result = new Result();
        MDNSDiscover.decode(packet, packetLength, result);
        return result;
    }

    static void decode(byte[] packet, int packetLength, Result result) throws IOException {
        short type;
        String fqdn;
        int i;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet, 0, packetLength));
        short transactionID = dis.readShort();
        short flags = dis.readShort();
        int questions = dis.readUnsignedShort();
        int answers = dis.readUnsignedShort();
        int authorityRRs = dis.readUnsignedShort();
        int additionalRRs = dis.readUnsignedShort();
        for (i = 0; i < questions; ++i) {
            fqdn = MDNSDiscover.decodeFQDN(dis, packet, packetLength);
            type = dis.readShort();
            short qclass = dis.readShort();
        }
        for (i = 0; i < answers + authorityRRs + additionalRRs; ++i) {
            fqdn = MDNSDiscover.decodeFQDN(dis, packet, packetLength);
            type = dis.readShort();
            short aclass = dis.readShort();
            int ttl = dis.readInt();
            int length = dis.readUnsignedShort();
            byte[] data = new byte[length];
            dis.readFully(data);
            Record record = null;
            switch (type) {
                case 1: {
                    record = result.a = MDNSDiscover.decodeA(data);
                    break;
                }
                case 33: {
                    result.srv = MDNSDiscover.decodeSRV(data, packet, packetLength);
                    record = result.srv;
                    break;
                }
                case 12: {
                    MDNSDiscover.decodePTR(data, packet, packetLength);
                    break;
                }
                case 16: {
                    result.txt = MDNSDiscover.decodeTXT(data);
                    record = result.txt;
                    break;
                }
            }
            if (record == null) continue;
            record.fqdn = fqdn;
            record.ttl = ttl;
        }
    }

    private static SRV decodeSRV(byte[] srvData, byte[] packetData, int packetLength) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(srvData));
        SRV srv = new SRV();
        srv.priority = dis.readUnsignedShort();
        srv.weight = dis.readUnsignedShort();
        srv.port = dis.readUnsignedShort();
        srv.target = MDNSDiscover.decodeFQDN(dis, packetData, packetLength);
        return srv;
    }

    private static String typeString(short type) {
        switch (type) {
            case 1: {
                return "A";
            }
            case 12: {
                return "PTR";
            }
            case 33: {
                return "SRV";
            }
            case 16: {
                return "TXT";
            }
        }
        return "Unknown";
    }

    private static String decodePTR(byte[] ptrData, byte[] packet, int packetLength) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(ptrData));
        String fqdn = MDNSDiscover.decodeFQDN(dis, packet, packetLength);
        return fqdn;
    }

    private static A decodeA(byte[] data) throws IOException {
        if (data.length < 4) {
            throw new IOException("expected 4 bytes for IPv4 addr");
        }
        A a = new A();
        a.ipaddr = (data[0] & 0xFF) + "." + (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF);
        return a;
    }

    private static TXT decodeTXT(byte[] data) throws IOException {
        TXT txt = new TXT();
        txt.dict = new HashMap<String, String>();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        while (true) {
            String key;
            int length;
            try {
                length = dis.readUnsignedByte();
            }
            catch (EOFException e) {
                return txt;
            }
            byte[] segmentBytes = new byte[length];
            dis.readFully(segmentBytes);
            String segment = new String(segmentBytes);
            int pos = segment.indexOf(61);
            String value = null;
            if (pos != -1) {
                key = segment.substring(0, pos);
                value = segment.substring(pos + 1);
            } else {
                key = segment;
            }
            if (txt.dict.containsKey(key)) continue;
            txt.dict.put(key, value);
        }
    }

    private static String decodeFQDN(DataInputStream dis, byte[] packet, int packetLength) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean dot = false;
        do {
            int length;
            int pointerHopCount = 0;
            while (true) {
                if ((length = dis.readUnsignedByte()) == 0) {
                    return result.toString();
                }
                if ((length & 0xC0) != 192) break;
                if (++pointerHopCount * 2 >= packetLength) {
                    throw new IOException("cyclic empty references in domain name");
                }
                int offset = (length &= 0x3F) << 8 | dis.readUnsignedByte();
                dis = new DataInputStream(new ByteArrayInputStream(packet, offset, packetLength - offset));
            }
            byte[] segment = new byte[length];
            dis.readFully(segment);
            if (dot) {
                result.append('.');
            }
            dot = true;
            result.append(new String(segment));
        } while (result.length() <= packetLength);
        throw new IOException("cyclic non-empty references in domain name");
    }

    public static class Result {
        public A a;
        public SRV srv;
        public TXT txt;
    }

    public static class TXT
    extends Record {
        public Map<String, String> dict;
    }

    public static class SRV
    extends Record {
        public int priority;
        public int weight;
        public int port;
        public String target;
    }

    public static class A
    extends Record {
        public String ipaddr;
    }

    public static class Record {
        public String fqdn;
        public int ttl;
    }

    public static interface Callback {
        public void onResult(Result var1);
    }
}

