/*
 * Decompiled with CFR 0.152.
 */
package com.youview.tinydnssd;

import android.os.Handler;
import android.os.SystemClock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class MapDebouncer<Key, Value> {
    private final int mDebouncePeriodMillis;
    private final Listener<Key, Value> mListener;
    private final Map<Key, Value> mBackingMap = new HashMap<Key, Value>();
    private final Map<Key, Long> mRemovalSchedule = new HashMap<Key, Long>();
    private long mNextScheduledRemoval;
    private Handler mHandler;
    private final Runnable mRemoveRunnable = new Runnable(){

        @Override
        public void run() {
            long currentTime = SystemClock.uptimeMillis();
            Iterator it = MapDebouncer.this.mRemovalSchedule.entrySet().iterator();
            long nextScheduleTime = Long.MAX_VALUE;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                long itemTime = (Long)entry.getValue();
                if (itemTime <= currentTime) {
                    Object key = entry.getKey();
                    MapDebouncer.this.performUpdate(key, null);
                    it.remove();
                    continue;
                }
                if (itemTime >= nextScheduleTime) continue;
                nextScheduleTime = itemTime;
            }
            MapDebouncer.this.mNextScheduledRemoval = 0L;
            if (nextScheduleTime < Long.MAX_VALUE) {
                MapDebouncer.this.mHandler.postAtTime(MapDebouncer.this.mRemoveRunnable, nextScheduleTime);
                MapDebouncer.this.mNextScheduledRemoval = nextScheduleTime;
            }
        }
    };

    MapDebouncer(int debouncePeriodMillis, Listener<Key, Value> listener) {
        if (debouncePeriodMillis < 0) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        this.mDebouncePeriodMillis = debouncePeriodMillis;
        this.mListener = listener;
    }

    void put(Key key, Value newValue) {
        Value oldValue;
        if (this.mDebouncePeriodMillis == 0) {
            this.mListener.put(key, newValue);
            return;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if ((oldValue = this.mBackingMap.get(key)) == null) {
            if (newValue != null) {
                this.immediateUpdate(key, newValue);
            }
        } else if (newValue == null) {
            this.timedRemoval(key);
        } else if (oldValue.equals(newValue)) {
            this.cancelTimedRemoval(key);
        } else {
            this.immediateUpdate(key, newValue);
        }
    }

    private void performUpdate(Key key, Value value) {
        this.mBackingMap.put(key, value);
        this.mListener.put(key, value);
    }

    private void cancelTimedRemoval(Key key) {
        Long scheduled = this.mRemovalSchedule.remove(key);
        if (scheduled != null && scheduled == this.mNextScheduledRemoval) {
            long newSchedule = Long.MAX_VALUE;
            for (long time : this.mRemovalSchedule.values()) {
                if (time >= newSchedule) continue;
                newSchedule = time;
            }
            if (scheduled != newSchedule) {
                this.mHandler.removeCallbacks(this.mRemoveRunnable);
                if (newSchedule < Long.MAX_VALUE) {
                    this.mHandler.postAtTime(this.mRemoveRunnable, newSchedule);
                }
            }
        }
    }

    private void timedRemoval(Key key) {
        long removalTime = SystemClock.uptimeMillis() + (long)this.mDebouncePeriodMillis;
        if (this.mNextScheduledRemoval == 0L) {
            this.mNextScheduledRemoval = removalTime;
            this.mHandler.postAtTime(this.mRemoveRunnable, removalTime);
        } else if (removalTime < this.mNextScheduledRemoval) {
            this.mHandler.removeCallbacks(this.mRemoveRunnable);
            this.mNextScheduledRemoval = removalTime;
            this.mHandler.postAtTime(this.mRemoveRunnable, removalTime);
        }
        this.mRemovalSchedule.put(key, removalTime);
    }

    private void immediateUpdate(Key key, Value value) {
        this.cancelTimedRemoval(key);
        this.performUpdate(key, value);
    }

    void clear() {
        this.mBackingMap.clear();
        this.mRemovalSchedule.clear();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRemoveRunnable);
        }
        this.mNextScheduledRemoval = 0L;
    }

    static interface Listener<Key, Value> {
        public void put(Key var1, Value var2);
    }
}

