/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.constant.YunpianConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunpianConf
implements YunpianConstant {
    static final Logger LOG = LoggerFactory.getLogger(YunpianConf.class);
    private Properties _conf = new Properties();
    private File file;
    private String apikey;
    private InputStream in;
    private Properties props;

    public YunpianConf with(String apikey) {
        this.apikey = apikey;
        return this;
    }

    public YunpianConf with(File file) {
        this.file = file;
        return this;
    }

    public YunpianConf with(InputStream in) {
        this.in = in;
        return this;
    }

    public YunpianConf with(Properties props) {
        this.props = props;
        return this;
    }

    public YunpianConf build() {
        try {
            this.load(this.file);
            this.load(this.in);
            this.load(this.props);
            if (this._conf.isEmpty()) {
                LOG.info("load default yunpian.properties");
                this.load(YunpianClient.class.getResourceAsStream("/yunpian.properties"));
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e.fillInStackTrace());
        }
        finally {
            this.file = null;
            this.in = null;
            this.props = null;
        }
        LOG.info("apikey-{} conf-{}", (Object)this.getApikey(), (Object)this._conf.toString());
        return this;
    }

    final YunpianConf load(File file) throws Exception {
        if (file != null && file.exists()) {
            this.load(new FileInputStream(file));
        }
        return this;
    }

    final YunpianConf load(InputStream in) throws Exception {
        if (in != null) {
            this._conf.load(in);
        }
        return this;
    }

    final YunpianConf load(Properties props) {
        if (props != null) {
            this._conf.clear();
            this._conf.putAll((Map<?, ?>)props);
        }
        return this;
    }

    public String getConf(String key, String defVal) {
        return System.getProperty(key, this._conf.getProperty(key, defVal));
    }

    public int getConfInt(String key, String defVal) {
        String v = this.getConf(key, defVal);
        return Integer.parseInt(v);
    }

    public String getApikey() {
        return System.getProperty("yp.apikey", this._conf.getProperty("yp.apikey", this.apikey));
    }

    public String toString() {
        return "YunpianConf-" + this._conf.toString();
    }
}

