/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.Sign;
import com.yunpian.sdk.model.SignRecord;
import com.yunpian.sdk.util.JsonUtil;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class SignApi
extends YunpianApi {
    public static final String NAME = "sign";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.sign.host", "https://sms.yunpian.com"));
    }

    public Result<Sign> add(Map<String, String> param) {
        Result<Sign> r = new Result<Sign>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", NAME);
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Sign> h = new YunpianApiResult.MapResultHandler<Sign>(){

            @Override
            public Sign data(Map<String, String> rsp) {
                switch (SignApi.this.version()) {
                    case "v2": {
                        return JsonUtil.fromJson(rsp.get(SignApi.NAME), Sign.class);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SignApi.this.version());
            }
        };
        try {
            return this.path("add.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Sign> update(Map<String, String> param) {
        Result<Sign> r = new Result<Sign>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "old_sign");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Sign> h = new YunpianApiResult.MapResultHandler<Sign>(){

            @Override
            public Sign data(Map<String, String> rsp) {
                switch (SignApi.this.version()) {
                    case "v2": {
                        return JsonUtil.fromJson(rsp.get(SignApi.NAME), Sign.class);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SignApi.this.version());
            }
        };
        try {
            return this.path("update.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<SignRecord> get(Map<String, String> param) {
        Result<SignRecord> r = new Result<SignRecord>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SignRecord> h = new YunpianApiResult.MapResultHandler<SignRecord>(){

            @Override
            public SignRecord data(Map<String, String> rsp) {
                switch (SignApi.this.version()) {
                    case "v2": {
                        TypeToken<List<Sign>> token = new TypeToken<List<Sign>>(){};
                        List signs = (List)JsonUtil.fromJson(rsp.get(SignApi.NAME), token.getType());
                        int total = Integer.valueOf(rsp.get("total"));
                        SignRecord signRecord = new SignRecord();
                        signRecord.setSign(signs);
                        signRecord.setTotal(total);
                        return signRecord;
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SignApi.this.version());
            }
        };
        try {
            return this.path("get.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }
}

