/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class TelegramNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "<strong>#{instance.registration.name}</strong>/#{instance.id} is <strong>#{event.statusInfo.status}</strong>";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private String apiUrl = "https://api.telegram.org";
    private String chatId;
    private String authToken;
    private String parse_mode = "HTML";
    private boolean disableNotify = false;
    private Expression message = this.parser.parseExpression("<strong>#{instance.registration.name}</strong>/#{instance.id} is <strong>#{event.statusInfo.status}</strong>", ParserContext.TEMPLATE_EXPRESSION);

    public TelegramNotifier(InstanceRepository repository) {
        super(repository);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> {
            Void cfr_ignored_0 = (Void)this.restTemplate.getForObject(this.buildUrl(), Void.class, this.createMessage(event, instance));
        });
    }

    protected String buildUrl() {
        return String.format("%s/bot%s/sendmessage?chat_id={chat_id}&text={text}&parse_mode={parse_mode}&disable_notification={disable_notification}", this.apiUrl, this.authToken);
    }

    private Map<String, Object> createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("chat_id", this.chatId);
        parameters.put("parse_mode", this.parse_mode);
        parameters.put("disable_notification", this.disableNotify);
        parameters.put("text", this.getText(event, instance));
        return parameters;
    }

    protected String getText(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setRestTemplate(RestTemplateBuilder builder) {
        this.restTemplate = builder.build();
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isDisableNotify() {
        return this.disableNotify;
    }

    public void setDisableNotify(boolean disableNotify) {
        this.disableNotify = disableNotify;
    }

    public String getParse_mode() {
        return this.parse_mode;
    }

    public void setParse_mode(String parse_mode) {
        this.parse_mode = parse_mode;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }
}

