/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.memcached;

import de.flapdoodle.embed.memcached.Command;
import de.flapdoodle.embed.memcached.MemcachedExecutable;
import de.flapdoodle.embed.memcached.config.MemcachedConfig;
import de.flapdoodle.embed.memcached.config.SupportConfig;
import de.flapdoodle.embed.memcached.runtime.Memcached;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class MemcachedProcess
extends AbstractProcess<MemcachedConfig, MemcachedExecutable, MemcachedProcess> {
    private static Logger logger = Logger.getLogger(MemcachedProcess.class.getName());
    boolean stopped = false;

    public MemcachedProcess(Distribution distribution, MemcachedConfig config, IRuntimeConfig runtimeConfig, MemcachedExecutable memcachedExecutable) throws IOException {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, (Executable)memcachedExecutable);
    }

    protected Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed to listen on TCP port");
        ret.add("Address already in use");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        MemcachedProcess memcachedProcess = this;
        synchronized (memcachedProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("try to stop memcached");
                if (!this.sendKillToProcess()) {
                    logger.warning("could not kill memcached, try next");
                    if (!this.sendTermToProcess()) {
                        logger.warning("could not term memcached, try next");
                        if (!this.tryKillToProcess()) {
                            logger.warning("could not stop memcached the third time, try one last thing");
                        }
                    }
                }
                this.stopProcess();
            }
        }
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        super.onBeforeProcess(runtimeConfig);
        MemcachedConfig config = (MemcachedConfig)this.getConfig();
    }

    protected List<String> getCommandLine(Distribution distribution, MemcachedConfig config, IExtractedFileSet exe) throws IOException {
        return Memcached.enhanceCommandLinePlattformSpecific(distribution, Memcached.getCommandLine((MemcachedConfig)this.getConfig(), exe, this.pidFile()));
    }

    protected Map<String, String> getEnvironment(Distribution distribution, MemcachedConfig config, IExtractedFileSet exe) {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (distribution.getPlatform() == Platform.Linux) {
            environment.put("LD_LIBRARY_PATH", exe.executable().getParent());
        } else if (distribution.getPlatform() == Platform.OS_X) {
            environment.put("DYLD_LIBRARY_PATH", exe.executable().getParent());
        }
        return environment;
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("server listening", this.knownFailureMessages(), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        Processors.connect((Reader)process.getError(), (IStreamProcessor)logWatch);
        logWatch.waitForResult(((MemcachedConfig)this.getConfig()).timeout().getStartupTimeout());
        if (!logWatch.isInitWithSuccess()) {
            throw new IOException("Could not start process:" + logWatch.getOutput());
        }
        if (Distribution.detectFor((IVersion)((MemcachedConfig)this.getConfig()).version()).getPlatform() == Platform.Windows) {
            this.setProcessId(process.getPid());
        } else {
            this.setProcessId(MemcachedProcess.getPidFromFile((File)this.pidFile()));
        }
    }

    protected void cleanupInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopStaleProcess(File pidFile, IVersion version) throws IOException {
        try {
            int pid = MemcachedProcess.getPidFromFile((File)pidFile);
            Platform platform = Distribution.detectFor((IVersion)version).getPlatform();
            Class<MemcachedProcess> clazz = MemcachedProcess.class;
            synchronized (MemcachedProcess.class) {
                logger.info("try to stop memcached");
                if (!Processes.killProcess((ISupportConfig)new SupportConfig(Command.MemcacheD), (Platform)platform, (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)Processors.console()), (int)pid)) {
                    logger.warning("could not kill memcached, try next");
                    if (!Processes.termProcess((ISupportConfig)new SupportConfig(Command.MemcacheD), (Platform)platform, (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)Processors.console()), (int)pid)) {
                        logger.warning("could not term memcached, try next");
                        if (!Processes.tryKillProcess((ISupportConfig)new SupportConfig(Command.MemcacheD), (Platform)platform, (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)Processors.console()), (int)pid)) {
                            logger.warning("could not stop memcached the third time, try one last thing");
                        }
                    }
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        {
            return;
        }
    }
}

