/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.config.store.FileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FileSet {
    private final List<Entry> _entries;

    public FileSet(Collection<Entry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is NULL");
        }
        this._entries = Collections.unmodifiableList(new ArrayList<Entry>(entries));
        boolean oneOrMoreExecutableFound = false;
        for (Entry e : this._entries) {
            if (e.type() != FileType.Executable) continue;
            oneOrMoreExecutableFound = true;
            break;
        }
        if (!oneOrMoreExecutableFound) {
            throw new IllegalArgumentException("there is no executable in this file set");
        }
    }

    public List<Entry> entries() {
        return this._entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Entry> _entries = new ArrayList<Entry>();

        public Builder addEntry(FileType type, String filename) {
            return this.addEntry(type, filename, ".*" + filename);
        }

        public Builder addEntry(FileType type, String filename, String pattern) {
            return this.addEntry(type, filename, Pattern.compile(pattern, 2));
        }

        public Builder addEntry(FileType type, String filename, Pattern pattern) {
            this._entries.add(new Entry(type, filename, pattern));
            return this;
        }

        public FileSet build() {
            return new FileSet(this._entries);
        }
    }

    public static class Entry {
        private final FileType _type;
        private final String _destination;
        private final Pattern _matchingPattern;

        public Entry(FileType type, String destination, Pattern matchingPattern) {
            this._type = type;
            this._destination = destination;
            this._matchingPattern = matchingPattern;
        }

        public FileType type() {
            return this._type;
        }

        public String destination() {
            return this._destination;
        }

        public Pattern matchingPattern() {
            return this._matchingPattern;
        }
    }
}

