/*
 * Decompiled with CFR 0.152.
 */
package es.cenobit.struts2.json;

import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import es.cenobit.struts2.json.JsonSerializerBuilder;
import es.cenobit.struts2.json.JsonServices;
import es.cenobit.struts2.json.annotations.Json;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class JsonActionInvocation
extends DefaultActionInvocation
implements ActionInvocation {
    private static final long serialVersionUID = -4888602055717841526L;
    private static final Logger LOG = LoggerFactory.getLogger(JsonActionInvocation.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private JsonServices jsonService;

    public JsonActionInvocation(Map<String, Object> extraContext, boolean pushAction) {
        super(extraContext, pushAction);
    }

    @Inject(value="jsonServices")
    public void setJsonService(JsonServices jsonService) {
        this.jsonService = jsonService;
    }

    public Result getResult() throws Exception {
        Result proxyResult;
        ActionProxy aProxy;
        Result returnResult = this.result;
        while (returnResult instanceof ActionChainResult && (aProxy = ((ActionChainResult)returnResult).getProxy()) != null && (proxyResult = aProxy.getInvocation().getResult()) != null && aProxy.getExecuteResult()) {
            returnResult = proxyResult;
        }
        return returnResult;
    }

    public Result createResult() throws Exception {
        return super.createResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke() throws Exception {
        String profileKey = "invoke: ";
        try {
            UtilTimerStack.push((String)profileKey);
            if (this.executed) {
                throw new IllegalStateException("Action has already executed");
            }
            if (this.interceptors.hasNext()) {
                InterceptorMapping interceptor = (InterceptorMapping)this.interceptors.next();
                String interceptorMsg = "interceptor: " + interceptor.getName();
                UtilTimerStack.push((String)interceptorMsg);
                try {
                    this.resultCode = interceptor.getInterceptor().intercept((ActionInvocation)this);
                }
                finally {
                    UtilTimerStack.pop((String)interceptorMsg);
                }
            } else {
                this.resultCode = this.invokeActionOnly();
            }
            if (!this.executed) {
                if (this.preResultListeners != null) {
                    for (Object preResultListener : this.preResultListeners) {
                        PreResultListener listener = (PreResultListener)preResultListener;
                        String _profileKey = "preResultListener: ";
                        try {
                            UtilTimerStack.push((String)_profileKey);
                            listener.beforeResult((ActionInvocation)this, this.resultCode);
                        }
                        finally {
                            UtilTimerStack.pop((String)_profileKey);
                        }
                    }
                }
                if (this.proxy.getExecuteResult()) {
                    this.executeResult();
                }
                this.executed = true;
            }
            String string = this.resultCode;
            return string;
        }
        finally {
            UtilTimerStack.pop((String)profileKey);
        }
    }

    public String invokeActionOnly() throws Exception {
        return this.invokeAction(this.getAction(), this.proxy.getConfig());
    }

    protected void createAction(Map<String, Object> contextMap) {
        String timerKey = "actionCreate: " + this.proxy.getActionName();
        try {
            UtilTimerStack.push((String)timerKey);
            this.action = this.objectFactory.buildAction(this.proxy.getActionName(), this.proxy.getNamespace(), this.proxy.getConfig(), contextMap);
        }
        catch (InstantiationException e) {
            throw new XWorkException("Unable to intantiate Action!", (Throwable)e, (Object)this.proxy.getConfig());
        }
        catch (IllegalAccessException e) {
            throw new XWorkException("Illegal access to constructor, is it public?", (Throwable)e, (Object)this.proxy.getConfig());
        }
        catch (Exception e) {
            String gripe = this.proxy == null ? "Whoa!  No ActionProxy instance found in current ActionInvocation.  This is bad ... very bad" : (this.proxy.getConfig() == null ? "Sheesh.  Where'd that ActionProxy get to?  I can't find it in the current ActionInvocation!?" : (this.proxy.getConfig().getClassName() == null ? "No Action defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'" : "Unable to instantiate Action, " + this.proxy.getConfig().getClassName() + ",  defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'"));
            gripe = gripe + (" -- " + e.getMessage() != null ? e.getMessage() : " [no message in exception]");
            throw new XWorkException(gripe, (Throwable)e, (Object)this.proxy.getConfig());
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
        if (this.actionEventListener != null) {
            this.action = this.actionEventListener.prepare(this.action, this.stack);
        }
    }

    protected Map<String, Object> createContextMap() {
        Map contextMap;
        if (this.extraContext != null && this.extraContext.containsKey("com.opensymphony.xwork2.util.ValueStack.ValueStack")) {
            this.stack = (ValueStack)this.extraContext.get("com.opensymphony.xwork2.util.ValueStack.ValueStack");
            if (this.stack == null) {
                throw new IllegalStateException("There was a null Stack set into the extra params.");
            }
            contextMap = this.stack.getContext();
        } else {
            this.stack = this.valueStackFactory.createValueStack();
            contextMap = this.stack.getContext();
        }
        if (this.extraContext != null) {
            contextMap.putAll(this.extraContext);
        }
        contextMap.put("com.opensymphony.xwork2.ActionContext.actionInvocation", this);
        contextMap.put("com.opensymphony.xwork2.ActionContext.container", this.container);
        return contextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeResult() throws Exception {
        this.result = this.createResult();
        String timerKey = "executeResult: " + this.getResultCode();
        try {
            UtilTimerStack.push((String)timerKey);
            if (this.result != null) {
                this.result.execute((ActionInvocation)this);
            } else {
                if (this.resultCode != null && !"none".equals(this.resultCode)) {
                    throw new ConfigurationException("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode(), (Object)this.proxy.getConfig());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No result returned for action " + this.getAction().getClass().getName() + " at " + this.proxy.getConfig().getLocation(), new String[0]);
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    public void init(ActionProxy proxy) {
        this.proxy = proxy;
        Map<String, Object> contextMap = this.createContextMap();
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null) {
            actionContext.setActionInvocation((ActionInvocation)this);
        }
        this.createAction(contextMap);
        if (this.pushAction) {
            this.stack.push(this.action);
            contextMap.put("action", this.action);
        }
        this.invocationContext = new ActionContext(contextMap);
        this.invocationContext.setName(proxy.getActionName());
        ArrayList interceptorList = new ArrayList(proxy.getConfig().getInterceptors());
        this.interceptors = interceptorList.iterator();
    }

    protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
        String methodName = this.proxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing action method = " + actionConfig.getMethodName(), new String[0]);
        }
        String timerKey = "invokeAction: " + this.proxy.getActionName();
        try {
            Method method;
            Object methodResult;
            boolean methodCalled;
            block20: {
                UtilTimerStack.push((String)timerKey);
                methodCalled = false;
                methodResult = null;
                method = null;
                try {
                    method = this.getAction().getClass().getMethod(methodName, EMPTY_CLASS_ARRAY);
                }
                catch (NoSuchMethodException e) {
                    try {
                        String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                        method = this.getAction().getClass().getMethod(altMethodName, EMPTY_CLASS_ARRAY);
                    }
                    catch (NoSuchMethodException e1) {
                        if (this.unknownHandlerManager.hasUnknownHandlers()) {
                            try {
                                methodResult = this.unknownHandlerManager.handleUnknownMethod(action, methodName);
                                methodCalled = true;
                                break block20;
                            }
                            catch (NoSuchMethodException e2) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
            }
            if (!methodCalled) {
                methodResult = method.invoke(action, EMPTY_OBJECT_ARRAY);
            }
            if (this.containsAnnotation(actionConfig, method)) {
                String string = this.saveJsonResult(actionConfig, methodResult, method);
                return string;
            }
            String string = this.saveResult(actionConfig, methodResult);
            return string;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The " + methodName + "() is not defined in action " + this.getAction().getClass() + "");
        }
        catch (InvocationTargetException e) {
            String result;
            Throwable t = e.getTargetException();
            if (this.actionEventListener != null && (result = this.actionEventListener.handleException(t, this.getStack())) != null) {
                String string = result;
                return string;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    protected String saveJsonResult(ActionConfig actionConfig, Object methodResult, Method method) throws IOException, ClassNotFoundException {
        if (methodResult instanceof Result) {
            return super.saveResult(actionConfig, methodResult);
        }
        HttpServletResponse response = (HttpServletResponse)this.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String[] excludedFieldNames = this.determineExcludedFieldsNames(actionConfig, method);
            String json = this.gson(excludedFieldNames).toJson(methodResult);
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(json);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LOG.error("Unable to serialize data width Gson API", (Throwable)e, new String[0]);
            LOG.error(e.getMessage(), (Throwable)e, new String[0]);
            throw e;
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid action class configuration that references an unknown class named [" + actionConfig.getClassName() + "]", (Throwable)e, new String[0]);
            LOG.error(e.getMessage(), (Throwable)e, new String[0]);
            throw e;
        }
        return null;
    }

    private Gson gson(String[] excludedFieldNames) {
        LinkedHashSet<String> fieldsToExclude = new LinkedHashSet<String>(Arrays.asList(excludedFieldNames));
        return JsonSerializerBuilder.create(fieldsToExclude, new Class[0]);
    }

    private boolean containsAnnotation(ActionConfig actionConfig, Method method) throws ClassNotFoundException {
        Annotation[] annotations;
        if (method.isAnnotationPresent(Json.class)) {
            return true;
        }
        if (this.jsonService.getJsonAnnotation(actionConfig) != null) {
            return true;
        }
        for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
            String typeName = annotation.annotationType().getName();
            if (!Json.class.getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public String[] determineExcludedFieldsNames(ActionConfig actionConfig, Method method) throws ClassNotFoundException {
        if (method.isAnnotationPresent(Json.class)) {
            return method.getAnnotation(Json.class).exclude();
        }
        return this.jsonService.determineExcludedFieldsNames(actionConfig);
    }

    protected Gson createJsonSerializer() {
        return JsonSerializerBuilder.create();
    }

    public ActionInvocation serialize() {
        JsonActionInvocation that = this;
        that.container = null;
        return that;
    }

    public ActionInvocation deserialize(ActionContext actionContext) {
        JsonActionInvocation that = this;
        that.container = actionContext.getContainer();
        return that;
    }
}

