/*
 * Decompiled with CFR 0.152.
 */
package es.cenobit.struts2.json;

import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import es.cenobit.struts2.json.JsonSerializerBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;

public class JsonResult
implements Result {
    private static final long serialVersionUID = 6082890994954880645L;
    private static final Logger LOG = LoggerFactory.getLogger(JsonResult.class);
    private Gson gson = JsonSerializerBuilder.create();
    private String root;

    public void execute(ActionInvocation invocation) throws Exception {
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletResponse response = (HttpServletResponse)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(this.gson.toJson(this.findRootObject(invocation)));
            ((Writer)writer).flush();
        }
        catch (IOException exception) {
            LOG.error(exception.getMessage(), (Throwable)exception, new String[0]);
            throw exception;
        }
    }

    protected Object findRootObject(ActionInvocation invocation) {
        Object rootObject;
        if (this.root != null) {
            ValueStack stack = invocation.getStack();
            rootObject = stack.findValue(this.root);
        } else {
            rootObject = invocation.getStack().peek();
        }
        return rootObject;
    }
}

