/*
 * Decompiled with CFR 0.152.
 */
package es.cenobit.struts2.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import es.cenobit.struts2.json.annotations.DontExpose;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class JsonSerializerExclusionStrategy
implements ExclusionStrategy {
    private final Set toExcludeClasses;
    private final Set<String> fieldsToExclude;

    public JsonSerializerExclusionStrategy(Set<String> fieldsToExclude, Class<?> ... classes) {
        this.fieldsToExclude = fieldsToExclude;
        this.toExcludeClasses = new LinkedHashSet(Arrays.asList(classes));
    }

    public boolean shouldSkipField(FieldAttributes f) {
        if (f.getAnnotation(DontExpose.class) != null) {
            return true;
        }
        if (this.fieldsToExclude == null || this.fieldsToExclude.isEmpty()) {
            return false;
        }
        for (String fieldToExclude : this.fieldsToExclude) {
            String[] split;
            if (fieldToExclude == null || fieldToExclude.lastIndexOf(46) == -1 || (split = fieldToExclude.split("\\.")) == null || split.length <= 1) continue;
            String fieldClassName = split[split.length - 2].toLowerCase();
            String fieldAttrName = split[split.length - 1].toLowerCase();
            String className = this.className(f).toLowerCase();
            String classAttrName = f.getName().toLowerCase();
            if (!className.equals(fieldClassName) || !classAttrName.equals(fieldAttrName)) continue;
            return true;
        }
        return this.fieldsToExclude.contains(f.getName());
    }

    private String className(FieldAttributes f) {
        String declaringClass = f.getDeclaringClass().toString();
        if (declaringClass.indexOf(36) != -1) {
            int index = declaringClass.lastIndexOf(36);
            return declaringClass.substring(index + 1, declaringClass.length());
        }
        if (declaringClass.indexOf(46) != -1) {
            int index = declaringClass.lastIndexOf(46);
            return declaringClass.substring(index + 1, declaringClass.length());
        }
        return declaringClass;
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return this.toExcludeClasses.contains(clazz);
    }
}

