/*
 * Decompiled with CFR 0.152.
 */
package es.cenobit.struts2.json;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import es.cenobit.struts2.json.JsonServices;
import es.cenobit.struts2.json.annotations.Json;
import java.lang.reflect.Method;
import java.util.Map;

public class JsonService
implements JsonServices {
    @Override
    public String[] determineExcludedFieldsNames(Class<?> actionClass, String methodName) {
        Method[] methods;
        Json jsonAnnotation = (Json)AnnotationUtils.findAnnotation(actionClass, Json.class);
        if (jsonAnnotation != null) {
            return jsonAnnotation.exclude();
        }
        for (Method method : methods = actionClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Json json = method.getAnnotation(Json.class);
            return json.exclude();
        }
        return new String[0];
    }

    @Override
    public String[] determineExcludedFieldsNames(ActionConfig actionConfig) {
        return this.determineExcludedFieldsNames(this.loadClass(actionConfig), actionConfig.getName());
    }

    @Override
    public Json getJsonAnnotation(Class<?> actionClass, String methodName) {
        Method[] methods;
        Json jsonAnnotation = (Json)AnnotationUtils.findAnnotation(actionClass, Json.class);
        if (jsonAnnotation != null) {
            return jsonAnnotation;
        }
        for (Method method : methods = actionClass.getMethods()) {
            Json json;
            if (!method.getName().equals(methodName) || (json = method.getAnnotation(Json.class)) == null) continue;
            return json;
        }
        return null;
    }

    @Override
    public Json getJsonAnnotation(ActionConfig actionConfig) {
        return this.getJsonAnnotation(this.loadClass(actionConfig), actionConfig.getName());
    }

    private Class<?> loadClass(ActionConfig actionConfig) {
        try {
            return ClassLoaderUtil.loadClass((String)actionConfig.getClassName(), this.getClass());
        }
        catch (ClassNotFoundException e) {
            try {
                return ((ObjectFactory)ActionContext.getContext().getInstance(ObjectFactory.class)).getClassInstance(actionConfig.getClassName());
            }
            catch (ClassNotFoundException ex) {
                try {
                    return this.getClassLoader().loadClass(actionConfig.getClassName());
                }
                catch (ClassNotFoundException exc) {
                    throw new RuntimeException("Invalid action class configuration that references an unknown class named [" + actionConfig.getClassName() + "]", exc);
                }
            }
        }
    }

    private ClassLoaderInterface getClassLoader() {
        Map application = ActionContext.getContext().getApplication();
        if (application != null) {
            return (ClassLoaderInterface)application.get("__current_class_loader_interface");
        }
        return null;
    }
}

