/*
 * Decompiled with CFR 0.152.
 */
package es.cenobit.struts2.json;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.WildcardHelper;
import com.opensymphony.xwork2.util.classloader.ReloadingClassLoader;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.finder.UrlSet;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import es.cenobit.struts2.json.ActionConfigBuilder;
import es.cenobit.struts2.json.annotations.Json;
import es.cenobit.struts2.json.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.struts2.StrutsException;

public class PackageBasedActionConfigBuilder
implements ActionConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PackageBasedActionConfigBuilder.class);
    private static final boolean EXTRACT_BASE_INTERFACES = true;
    private final Container container;
    private final Configuration configuration;
    private final ObjectFactory objectFactory;
    private String[] actionPackages;
    private String[] excludePackages;
    private String[] packageLocators;
    private String[] includeJars;
    private String[] conventionIncludeJars;
    private String packageLocatorsBasePackage;
    private boolean disableActionScanning = false;
    private boolean disablePackageLocatorsScanning = false;
    private boolean checkImplementsAction = true;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean devMode;
    private ReloadingClassLoader reloadingClassLoader;
    private boolean reload;
    private Set<String> fileProtocols;
    private boolean excludeParentClassLoader;
    private boolean eagerLoading = false;
    private FileManager fileManager;

    @Inject
    public PackageBasedActionConfigBuilder(Configuration configuration, Container container, ObjectFactory objectFactory) {
        this.configuration = configuration;
        this.container = container;
        this.objectFactory = objectFactory;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equals(mode);
    }

    @Inject(value="struts.json.classes.reload")
    public void setReload(String reload) {
        this.reload = "true".equals(reload);
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Inject(value="struts.json.action.fileProtocols")
    public void setFileProtocols(String fileProtocols) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileProtocols)) {
            this.fileProtocols = TextParseUtil.commaDelimitedStringToSet((String)fileProtocols);
        }
    }

    @Inject(value="struts.json.exclude.parentClassLoader")
    public void setExcludeParentClassLoader(String exclude) {
        this.excludeParentClassLoader = "true".equals(exclude);
    }

    @Inject(value="struts.json.action.disableScanning", required=false)
    public void setDisableActionScanning(String disableActionScanning) {
        this.disableActionScanning = "true".equals(disableActionScanning);
    }

    @Inject(value="struts.json.action.includeJars", required=false)
    public void setIncludeJars(String includeJars) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)includeJars)) {
            this.includeJars = includeJars.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.action.includeJars", required=false)
    public void setConventionIncludeJars(String includeJars) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)includeJars)) {
            this.conventionIncludeJars = includeJars.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.json.package.locators.disable", required=false)
    public void setDisablePackageLocatorsScanning(String disablePackageLocatorsScanning) {
        this.disablePackageLocatorsScanning = "true".equals(disablePackageLocatorsScanning);
    }

    @Inject(value="struts.json.action.packages", required=false)
    public void setActionPackages(String actionPackages) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)actionPackages)) {
            this.actionPackages = actionPackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.json.action.checkImplementsAction", required=false)
    public void setCheckImplementsAction(String checkImplementsAction) {
        this.checkImplementsAction = "true".equals(checkImplementsAction);
    }

    @Inject(value="struts.json.exclude.packages", required=false)
    public void setExcludePackages(String excludePackages) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)excludePackages)) {
            this.excludePackages = excludePackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.json.package.locators", required=false)
    public void setPackageLocators(String packageLocators) {
        this.packageLocators = packageLocators.split("\\s*[,]\\s*");
    }

    @Inject(value="struts.json.package.locators.basePackage", required=false)
    public void setPackageLocatorsBase(String packageLocatorsBasePackage) {
        this.packageLocatorsBasePackage = packageLocatorsBasePackage;
    }

    @Override
    public void buildActionConfigs() {
        this.initReloadClassLoader();
        if (!this.disableActionScanning) {
            if (this.actionPackages == null && this.packageLocators == null) {
                throw new ConfigurationException("At least a list of action packages or action package locators must be given using one of the properties [struts.json.action.packages] or [struts.json.package.locators]");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading action configurations", new String[0]);
                if (this.actionPackages != null) {
                    LOG.trace("Actions being loaded from action packages " + Arrays.asList(this.actionPackages), new String[0]);
                }
                if (this.packageLocators != null) {
                    LOG.trace("Actions being loaded using package locators " + Arrays.asList(this.packageLocators), new String[0]);
                }
                if (this.excludePackages != null) {
                    LOG.trace("Excluding actions from packages " + Arrays.asList(this.excludePackages), new String[0]);
                }
            }
            Set<Class> classes = this.findActions();
            this.buildConfiguration(classes);
        }
    }

    protected void buildConfiguration(Set<Class> classes) {
        for (Class actionClass : classes) {
            Json jsonAnnotation = actionClass.getAnnotation(Json.class);
            if (this.cannotInstantiate(actionClass) && jsonAnnotation == null) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Class [#0] did not pass the instantiation test and will be ignored", new String[]{actionClass.getName()});
                continue;
            }
            if (this.eagerLoading) {
                try {
                    this.objectFactory.getClassInstance(actionClass.getName());
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Object Factory was unable to load class [#0]", (Throwable)e, new String[]{actionClass.getName()});
                    }
                    throw new StrutsException("Object Factory was unable to load class " + actionClass.getName(), (Throwable)e);
                }
            }
            String actionPackage = actionClass.getPackage().getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing class [#0] in package [#1]", new String[]{actionClass.getName(), actionPackage});
            }
            String defaultActionName = actionClass.getSimpleName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing defaultActionName [#0] in package [#1]", new String[]{defaultActionName, actionPackage});
            }
            Map<String, List<Json>> map = this.getActionAnnotations(actionClass);
        }
    }

    protected Map<String, List<Json>> getActionAnnotations(Class<?> actionClass) {
        Method[] methods = actionClass.getMethods();
        HashMap<String, List<Json>> map = new HashMap<String, List<Json>>();
        for (Method method : methods) {
            Json ann = method.getAnnotation(Json.class);
            if (ann == null) continue;
            map.put(method.getName(), Arrays.asList(ann));
        }
        return map;
    }

    protected boolean cannotInstantiate(Class<?> actionClass) {
        return actionClass.isAnnotation() || actionClass.isInterface() || actionClass.isEnum() || (actionClass.getModifiers() & 0x400) != 0 || actionClass.isAnonymousClass();
    }

    protected Set<Class> findActions() {
        HashSet<Class> classes;
        block3: {
            classes = new HashSet<Class>();
            try {
                if (this.actionPackages != null || this.packageLocators != null && !this.disablePackageLocatorsScanning) {
                    Test<String> classPackageTest = this.getClassPackageTest();
                    List<URL> urls = this.readUrls();
                    ClassFinder finder = new ClassFinder(this.getClassLoaderInterface(), urls, true, this.fileProtocols, classPackageTest);
                    Test<ClassFinder.ClassInfo> test = this.getActionClassTest();
                    classes.addAll(finder.findClasses(test));
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unable to scan named packages", (Throwable)ex, new String[0]);
            }
        }
        return classes;
    }

    protected boolean includeClassNameInActionScan(String className) {
        String classPackageName = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)className, (String)".");
        return (this.checkActionPackages(classPackageName) || this.checkPackageLocators(classPackageName)) && this.checkExcludePackages(classPackageName);
    }

    protected boolean checkExcludePackages(String classPackageName) {
        if (this.excludePackages != null && this.excludePackages.length > 0) {
            WildcardHelper wildcardHelper = new WildcardHelper();
            HashMap matchMap = new HashMap();
            for (String packageExclude : this.excludePackages) {
                int[] packagePattern = wildcardHelper.compilePattern(packageExclude);
                if (!wildcardHelper.match(matchMap, classPackageName, packagePattern)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkActionPackages(String classPackageName) {
        if (this.actionPackages != null) {
            for (String packageName : this.actionPackages) {
                String strictPackageName = packageName + ".";
                if (!classPackageName.equals(packageName) && !classPackageName.startsWith(strictPackageName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkPackageLocators(String classPackageName) {
        if (this.packageLocators != null && !this.disablePackageLocatorsScanning && classPackageName.length() > 0 && (this.packageLocatorsBasePackage == null || classPackageName.startsWith(this.packageLocatorsBasePackage))) {
            for (String packageLocator : this.packageLocators) {
                String[] splitted = classPackageName.split("\\.");
                if (!StringUtils.contains(splitted, packageLocator, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected Test<String> getClassPackageTest() {
        return new Test<String>(){

            public boolean test(String className) {
                return PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(className);
            }
        };
    }

    protected Test<ClassFinder.ClassInfo> getActionClassTest() {
        return new Test<ClassFinder.ClassInfo>(){

            public boolean test(ClassFinder.ClassInfo classInfo) {
                boolean inPackage = PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(classInfo.getName());
                try {
                    return inPackage && PackageBasedActionConfigBuilder.this.checkImplementsAction && Action.class.isAssignableFrom(classInfo.get());
                }
                catch (ClassNotFoundException ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Unable to load class [#0]", (Throwable)ex, new String[]{classInfo.getName()});
                    }
                    return false;
                }
            }
        };
    }

    private List<URL> readUrls() throws IOException {
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        ArrayList<URL> classesList = Collections.list(this.getClassLoaderInterface().getResources(""));
        for (URL url : classesList) {
            resourceUrls.addAll(this.fileManager.getAllPhysicalUrls(url));
        }
        return this.buildUrlSet(resourceUrls).getUrls();
    }

    private UrlSet buildUrlSet(List<URL> resourceUrls) throws IOException {
        UrlSet urlSet;
        block14: {
            ClassLoaderInterface classLoaderInterface;
            block13: {
                classLoaderInterface = this.getClassLoaderInterface();
                urlSet = new UrlSet(resourceUrls);
                urlSet = urlSet.include(new UrlSet(classLoaderInterface, this.fileProtocols));
                if (this.excludeParentClassLoader) {
                    ClassLoaderInterface parent = classLoaderInterface.getParent();
                    if (parent != null && this.isReloadEnabled()) {
                        parent = parent.getParent();
                    }
                    if (parent != null) {
                        urlSet = urlSet.exclude(parent);
                    }
                    try {
                        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                        urlSet = urlSet.exclude((ClassLoaderInterface)new ClassLoaderInterfaceDelegate(systemClassLoader.getParent()));
                    }
                    catch (SecurityException e) {
                        if (!LOG.isWarnEnabled()) break block13;
                        LOG.warn("Could not get the system classloader due to security constraints, there may be improper urls left to scan", new String[0]);
                    }
                }
            }
            urlSet = urlSet.includeClassesUrl(classLoaderInterface, new UrlSet.FileProtocolNormalizer(){

                public URL normalizeToFileProtocol(URL url) {
                    return PackageBasedActionConfigBuilder.this.fileManager.normalizeToFileProtocol(url);
                }
            });
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaEndorsedDirs();
            try {
                urlSet = urlSet.excludeJavaHome();
            }
            catch (NullPointerException e) {
                if (!LOG.isWarnEnabled()) break block14;
                LOG.warn("Could not exclude JAVA_HOME, is this a sandbox jvm?", new String[0]);
            }
        }
        urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
        String[] localIncludeJars = StringUtils.concat(this.includeJars, this.conventionIncludeJars);
        if (localIncludeJars != null) {
            List rawIncludedUrls = urlSet.getUrls();
            HashSet<URL> includeUrls = new HashSet<URL>();
            boolean[] patternUsed = new boolean[localIncludeJars.length];
            block4: for (URL url : rawIncludedUrls) {
                if (this.fileProtocols.contains(url.getProtocol())) {
                    for (int i = 0; i < localIncludeJars.length; ++i) {
                        String includeJar = localIncludeJars[i];
                        if (!Pattern.matches(includeJar, url.toExternalForm())) continue;
                        includeUrls.add(url);
                        patternUsed[i] = true;
                        continue block4;
                    }
                    continue;
                }
                includeUrls.add(url);
            }
            if (LOG.isWarnEnabled()) {
                for (int i = 0; i < patternUsed.length; ++i) {
                    if (patternUsed[i]) continue;
                    LOG.warn("The includeJars pattern [#0] did not match any jars in the classpath", new String[]{localIncludeJars[i]});
                }
            }
            return new UrlSet(includeUrls);
        }
        urlSet = urlSet.exclude(".*?\\.jar(!/|/)?");
        return urlSet;
    }

    protected ClassLoaderInterface getClassLoaderInterface() {
        if (this.isReloadEnabled()) {
            return new ClassLoaderInterfaceDelegate((ClassLoader)this.reloadingClassLoader);
        }
        ClassLoaderInterface classLoaderInterface = null;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.get("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(this.getClassLoader()));
    }

    protected void initReloadClassLoader() {
        if (this.isReloadEnabled() && this.reloadingClassLoader == null) {
            this.reloadingClassLoader = new ReloadingClassLoader(this.getClassLoader());
        }
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected boolean isReloadEnabled() {
        return this.devMode && this.reload;
    }

    @Override
    public boolean needsReload() {
        if (this.devMode && this.reload) {
            for (String url : this.loadedFileUrls) {
                if (!this.fileManager.fileNeedsReloading(url)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File [#0] changed, configuration will be reloaded", new String[]{url});
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.loadedFileUrls.clear();
    }
}

