/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.service.ServiceHub;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY)
public class PushMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.push.registry")
    private String pushRegistry;
    @Parameter(property="docker.skip.push", defaultValue="false")
    private boolean skipPush;
    @Parameter(property="docker.push.retries", defaultValue="0")
    private int retries;

    @Override
    public void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipPush) {
            return;
        }
        hub.getRegistryService().pushImages(this.getResolvedImages(), this.pushRegistry, this.retries, this.getRegistryConfig());
    }
}

