/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;

public class WebsphereTraditionalClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"com.ibm.ws.classloader.CompoundClassLoader", "com.ibm.ws.classloader.ProtectionClassLoader", "com.ibm.ws.bootstrap.ExtClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classloader, ClasspathOrder classpathOrderOut, LogNode log) {
        String classpath = (String)ReflectionUtils.invokeMethod(classloader, "getClassPath", false);
        classpathOrderOut.addClasspathElements(classpath, classloader, log);
    }
}

