/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.util.concurrent.TimeUnit;

public class SocketOptions {
    public static final long DEFAULT_CONNECT_TIMEOUT = 10L;
    public static final TimeUnit DEFAULT_CONNECT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_SO_KEEPALIVE = false;
    public static final boolean DEFAULT_SO_NO_DELAY = false;
    private final long connectTimeout;
    private final TimeUnit connectTimeoutUnit;
    private final boolean keepAlive;
    private final boolean tcpNoDelay;

    protected SocketOptions(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.connectTimeoutUnit = builder.connectTimeoutUnit;
        this.keepAlive = builder.keepAlive;
        this.tcpNoDelay = builder.tcpNoDelay;
    }

    protected SocketOptions(SocketOptions original) {
        this.connectTimeout = original.getConnectTimeout();
        this.connectTimeoutUnit = original.getConnectTimeoutUnit();
        this.keepAlive = original.isKeepAlive();
        this.tcpNoDelay = original.isTcpNoDelay();
    }

    public static SocketOptions copyOf(SocketOptions options) {
        return new SocketOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().build();
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeUnit getConnectTimeoutUnit() {
        return this.connectTimeoutUnit;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public static class Builder {
        private long connectTimeout = 10L;
        private TimeUnit connectTimeoutUnit = DEFAULT_CONNECT_TIMEOUT_UNIT;
        private boolean keepAlive = false;
        private boolean tcpNoDelay = false;

        private Builder() {
        }

        public Builder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
            LettuceAssert.isTrue(connectTimeout > 0L, "Connect timeout must be greater 0");
            LettuceAssert.notNull((Object)connectTimeoutUnit, "TimeUnit must not be null");
            this.connectTimeout = connectTimeout;
            this.connectTimeoutUnit = connectTimeoutUnit;
            return this;
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public SocketOptions build() {
            return new SocketOptions(this);
        }
    }
}

