/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.codec.CRC16;
import io.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotHash {
    public static final byte SUBKEY_START = 123;
    public static final byte SUBKEY_END = 125;
    public static final int SLOT_COUNT = 16384;

    private SlotHash() {
    }

    public static final int getSlot(String key) {
        return SlotHash.getSlot(key.getBytes());
    }

    public static final int getSlot(byte[] key) {
        return SlotHash.getSlot(ByteBuffer.wrap(key));
    }

    public static final int getSlot(ByteBuffer key) {
        int end;
        byte[] input = new byte[key.remaining()];
        key.duplicate().get(input);
        byte[] finalKey = input;
        int start = SlotHash.indexOf(input, (byte)123);
        if (start != -1 && (end = SlotHash.indexOf(input, start + 1, (byte)125)) != -1 && end != start + 1) {
            finalKey = new byte[end - (start + 1)];
            System.arraycopy(input, start + 1, finalKey, 0, finalKey.length);
        }
        return CRC16.crc16(finalKey) % 16384;
    }

    private static int indexOf(byte[] haystack, byte needle) {
        return SlotHash.indexOf(haystack, 0, needle);
    }

    private static int indexOf(byte[] haystack, int start, byte needle) {
        for (int i = start; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    static <K, V> Map<Integer, List<K>> partition(RedisCodec<K, V> codec, Iterable<K> keys) {
        HashMap<Integer, List<Integer>> partitioned = new HashMap<Integer, List<Integer>>();
        for (K key : keys) {
            int slot = SlotHash.getSlot(codec.encodeKey(key));
            if (!partitioned.containsKey(slot)) {
                partitioned.put(slot, new ArrayList());
            }
            Collection list = (Collection)partitioned.get(slot);
            list.add(key);
        }
        return partitioned;
    }

    static <K> Map<K, Integer> getSlots(Map<Integer, ? extends Iterable<K>> partitioned) {
        HashMap<K, Integer> result = new HashMap<K, Integer>();
        for (Map.Entry<Integer, Iterable<K>> entry : partitioned.entrySet()) {
            for (K key : entry.getValue()) {
                result.put(key, entry.getKey());
            }
        }
        return result;
    }
}

