/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StringValueListOutput<K, V>
extends CommandOutput<K, V, List<Value<String>>>
implements StreamingOutput<Value<String>> {
    private StreamingOutput.Subscriber<Value<String>> subscriber;

    public StringValueListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<Value<String>>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext(bytes == null ? Value.empty() : Value.fromNullable(this.decodeAscii(bytes)));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Value<String>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Value<String>> getSubscriber() {
        return this.subscriber;
    }
}

