/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ValueValueListOutput<K, V>
extends CommandOutput<K, V, List<Value<V>>>
implements StreamingOutput<Value<V>> {
    private StreamingOutput.Subscriber<Value<V>> subscriber;

    public ValueValueListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<Value<V>>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext(Value.fromNullable(bytes == null ? null : (Object)this.codec.decodeValue(bytes)));
    }

    @Override
    public void set(long integer) {
        this.subscriber.onNext(Value.fromNullable(integer));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Value<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Value<V>> getSubscriber() {
        return this.subscriber;
    }
}

