/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.ConstantDelay;
import io.lettuce.core.resource.DecorrelatedJitterDelay;
import io.lettuce.core.resource.EqualJitterDelay;
import io.lettuce.core.resource.ExponentialDelay;
import io.lettuce.core.resource.FullJitterDelay;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class Delay {
    private static long DEFAULT_LOWER_BOUND = 0L;
    private static long DEFAULT_UPPER_BOUND = TimeUnit.SECONDS.toMillis(30L);
    private static int DEFAULT_POWER_OF = 2;
    private static TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MILLISECONDS;
    private final TimeUnit timeUnit;

    protected Delay(TimeUnit timeUnit) {
        LettuceAssert.notNull((Object)timeUnit, "TimeUnit must not be null");
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public abstract long createDelay(long var1);

    public static Delay constant(int delay, TimeUnit timeUnit) {
        LettuceAssert.isTrue(delay >= 0, "Delay must be greater or equal to 0");
        return new ConstantDelay(delay, timeUnit);
    }

    public static Delay exponential() {
        return Delay.exponential(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, DEFAULT_TIMEUNIT, DEFAULT_POWER_OF);
    }

    public static Delay exponential(long lower, long upper, TimeUnit unit, int powersOf) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(powersOf > 1, "PowersOf must be greater than 1");
        return new ExponentialDelay(lower, upper, unit, powersOf);
    }

    public static Delay equalJitter() {
        return Delay.equalJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 1L, DEFAULT_TIMEUNIT);
    }

    public static Delay equalJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        return new EqualJitterDelay(lower, upper, base, unit);
    }

    public static Delay fullJitter() {
        return Delay.fullJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 1L, DEFAULT_TIMEUNIT);
    }

    public static Delay fullJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        return new FullJitterDelay(lower, upper, base, unit);
    }

    public static Supplier<Delay> decorrelatedJitter() {
        return Delay.decorrelatedJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 0L, DEFAULT_TIMEUNIT);
    }

    public static Supplier<Delay> decorrelatedJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 0L, "Base must be greater or equal to 0");
        return () -> new DecorrelatedJitterDelay(lower, upper, base, unit);
    }

    protected static long randomBetween(long min, long max) {
        if (min == max) {
            return min;
        }
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    protected static long applyBounds(long calculatedValue, long lower, long upper) {
        if (calculatedValue < lower) {
            return lower;
        }
        if (calculatedValue > upper) {
            return upper;
        }
        return calculatedValue;
    }

    public static interface StatefulDelay {
        public void reset();
    }
}

