/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.resource.ExponentialDelay;
import java.util.concurrent.TimeUnit;

class FullJitterDelay
extends ExponentialDelay {
    private final long base;
    private final long upper;

    FullJitterDelay(long lower, long upper, long base, TimeUnit unit) {
        super(lower, upper, unit, 2);
        this.upper = upper;
        this.base = base;
    }

    @Override
    public long createDelay(long attempt) {
        long temp = Math.min(this.upper, this.base * FullJitterDelay.calculatePowerOfTwo(attempt));
        long delay = temp / 2L + FullJitterDelay.randomBetween(0L, temp / 2L);
        return this.applyBounds(delay);
    }
}

