/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.NoopObservation;
import io.micrometer.observation.NoopObservationConvention;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.SimpleObservation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Observation {
    public static final Observation NOOP = NoopObservation.INSTANCE;

    public static Observation start(String name, ObservationRegistry registry) {
        return Observation.start(name, null, registry);
    }

    public static Observation start(String name, @Nullable Context context, @Nullable ObservationRegistry registry) {
        return Observation.createNotStarted(name, context, registry).start();
    }

    public static Observation createNotStarted(String name, @Nullable ObservationRegistry registry) {
        return Observation.createNotStarted(name, null, registry);
    }

    public static Observation createNotStarted(String name, @Nullable Context context, @Nullable ObservationRegistry registry) {
        if (registry == null || registry.isNoop() || !registry.observationConfig().isObservationEnabled(name, context)) {
            return NOOP;
        }
        return new SimpleObservation(name, registry, context == null ? new Context() : context);
    }

    public static <T extends Context> Observation createNotStarted(@Nullable ObservationConvention<T> customConvention, @NonNull ObservationConvention<T> defaultConvention, @NonNull T context, @NonNull ObservationRegistry registry) {
        ObservationConvention<T> convention = customConvention != null ? customConvention : registry.observationConfig().getObservationConvention(context, defaultConvention);
        return Observation.createNotStarted(convention, context, registry);
    }

    public static Observation start(ObservationConvention<? extends Context> observationConvention, @Nullable ObservationRegistry registry) {
        return Observation.start(observationConvention, null, registry);
    }

    public static <T extends Context> Observation start(ObservationConvention<T> observationConvention, @Nullable T context, @Nullable ObservationRegistry registry) {
        return Observation.createNotStarted(observationConvention, context, registry).start();
    }

    public static <T extends Context> Observation start(@Nullable ObservationConvention<T> customConvention, @NonNull ObservationConvention<T> defaultConvention, @NonNull T context, @NonNull ObservationRegistry registry) {
        return Observation.createNotStarted(customConvention, defaultConvention, context, registry).start();
    }

    public static Observation createNotStarted(ObservationConvention<? extends Context> observationConvention, @Nullable ObservationRegistry registry) {
        return Observation.createNotStarted(observationConvention, null, registry);
    }

    public static <T extends Context> Observation createNotStarted(ObservationConvention<T> observationConvention, @Nullable T context, @Nullable ObservationRegistry registry) {
        if (registry == null || registry.isNoop() || !registry.observationConfig().isObservationEnabled(observationConvention.getName(), context) || observationConvention == NoopObservationConvention.INSTANCE) {
            return NOOP;
        }
        return new SimpleObservation(observationConvention, registry, context == null ? new Context() : context);
    }

    public Observation contextualName(@Nullable String var1);

    public Observation parentObservation(Observation var1);

    public Observation lowCardinalityKeyValue(KeyValue var1);

    default public Observation lowCardinalityKeyValue(String key, String value) {
        return this.lowCardinalityKeyValue(KeyValue.of((String)key, (String)value));
    }

    default public Observation lowCardinalityKeyValues(KeyValues keyValues) {
        keyValues.stream().forEach(this::lowCardinalityKeyValue);
        return this;
    }

    public Observation highCardinalityKeyValue(KeyValue var1);

    default public Observation highCardinalityKeyValue(String key, String value) {
        return this.highCardinalityKeyValue(KeyValue.of((String)key, (String)value));
    }

    default public Observation highCardinalityKeyValues(KeyValues keyValues) {
        keyValues.stream().forEach(this::highCardinalityKeyValue);
        return this;
    }

    default public boolean isNoop() {
        return this == NOOP;
    }

    public Observation observationConvention(ObservationConvention<?> var1);

    public Observation error(Throwable var1);

    public Observation event(Event var1);

    public Observation start();

    public ContextView getContext();

    public void stop();

    public Scope openScope();

    default public void observe(Runnable runnable) {
        this.start();
        try (Scope scope = this.openScope();){
            runnable.run();
        }
        catch (Exception exception) {
            this.error(exception);
            throw exception;
        }
        finally {
            this.stop();
        }
    }

    default public <E extends Throwable> void observeChecked(CheckedRunnable<E> checkedRunnable) throws E {
        this.start();
        try (Scope scope = this.openScope();){
            checkedRunnable.run();
        }
        catch (Throwable error) {
            this.error(error);
            throw error;
        }
        finally {
            this.stop();
        }
    }

    default public <T> T observe(Supplier<T> supplier) {
        this.start();
        try {
            T t;
            block11: {
                Scope scope = this.openScope();
                try {
                    t = supplier.get();
                    if (scope == null) break block11;
                    scope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        this.error(exception);
                        throw exception;
                    }
                }
            }
            return t;
        }
        finally {
            this.stop();
        }
    }

    default public <T, E extends Throwable> T observeChecked(CheckedCallable<T, E> checkedCallable) throws E {
        this.start();
        try {
            T t;
            block11: {
                Scope scope = this.openScope();
                try {
                    t = checkedCallable.call();
                    if (scope == null) break block11;
                    scope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable error) {
                        this.error(error);
                        throw error;
                    }
                }
            }
            return t;
        }
        finally {
            this.stop();
        }
    }

    default public void scoped(Runnable runnable) {
        try (Scope scope = this.openScope();){
            runnable.run();
        }
        catch (Exception exception) {
            this.error(exception);
            throw exception;
        }
    }

    default public <E extends Throwable> void scopedChecked(CheckedRunnable<E> checkedRunnable) throws E {
        try (Scope scope = this.openScope();){
            checkedRunnable.run();
        }
        catch (Throwable throwable) {
            this.error(throwable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T scoped(Supplier<T> supplier) {
        try (Scope scope = this.openScope();){
            T t = supplier.get();
            return t;
        }
        catch (Exception exception) {
            this.error(exception);
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T, E extends Throwable> T scopedChecked(CheckedCallable<T, E> checkedCallable) throws E {
        try (Scope scope = this.openScope();){
            T t = checkedCallable.call();
            return t;
        }
        catch (Throwable error) {
            this.error(error);
            throw error;
        }
    }

    public static void tryScoped(@Nullable Observation parent, Runnable action) {
        if (parent != null) {
            parent.scoped(action);
        } else {
            action.run();
        }
    }

    public static <E extends Throwable> void tryScopedChecked(@Nullable Observation parent, CheckedRunnable<E> checkedRunnable) throws E {
        if (parent != null) {
            parent.scopedChecked(checkedRunnable);
        } else {
            checkedRunnable.run();
        }
    }

    public static <T> T tryScoped(@Nullable Observation parent, Supplier<T> action) {
        if (parent != null) {
            return parent.scoped(action);
        }
        return action.get();
    }

    public static <T, E extends Throwable> T tryScopedChecked(@Nullable Observation parent, CheckedCallable<T, E> checkedCallable) throws E {
        if (parent != null) {
            return parent.scopedChecked(checkedCallable);
        }
        return checkedCallable.call();
    }

    public static class Context
    implements ContextView {
        private final Map<Object, Object> map = new HashMap<Object, Object>();
        private String name;
        @Nullable
        private String contextualName;
        @Nullable
        private Throwable error;
        @Nullable
        private Observation parentObservation;
        private final Set<KeyValue> lowCardinalityKeyValues = new LinkedHashSet<KeyValue>();
        private final Set<KeyValue> highCardinalityKeyValues = new LinkedHashSet<KeyValue>();

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getContextualName() {
            return this.contextualName;
        }

        public void setContextualName(@Nullable String contextualName) {
            this.contextualName = contextualName;
        }

        @Override
        @Nullable
        public Observation getParentObservation() {
            return this.parentObservation;
        }

        public void setParentObservation(@Nullable Observation parentObservation) {
            this.parentObservation = parentObservation;
        }

        @Override
        public Optional<Throwable> getError() {
            return Optional.ofNullable(this.error);
        }

        public void setError(Throwable error) {
            this.error = error;
        }

        public <T> Context put(Object key, T object) {
            this.map.put(key, object);
            return this;
        }

        @Override
        @Nullable
        public <T> T get(Object key) {
            return (T)this.map.get(key);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        @NonNull
        public <T> T getRequired(Object key) {
            Object object = this.map.get(key);
            if (object == null) {
                throw new IllegalArgumentException("Context does not have an entry for key [" + key + "]");
            }
            return (T)object;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public <T> T getOrDefault(Object key, T defaultObject) {
            return (T)this.map.getOrDefault(key, defaultObject);
        }

        public <T> T computeIfAbsent(Object key, Function<Object, ? extends T> mappingFunction) {
            return this.map.computeIfAbsent(key, mappingFunction);
        }

        public void clear() {
            this.map.clear();
        }

        public Context addLowCardinalityKeyValue(KeyValue keyValue) {
            this.lowCardinalityKeyValues.add(keyValue);
            return this;
        }

        public Context addHighCardinalityKeyValue(KeyValue keyValue) {
            this.highCardinalityKeyValues.add(keyValue);
            return this;
        }

        public Context addLowCardinalityKeyValues(KeyValues keyValues) {
            keyValues.stream().forEach(this::addLowCardinalityKeyValue);
            return this;
        }

        public Context addHighCardinalityKeyValues(KeyValues keyValues) {
            keyValues.stream().forEach(this::addHighCardinalityKeyValue);
            return this;
        }

        @Override
        @NonNull
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(this.lowCardinalityKeyValues);
        }

        @Override
        @NonNull
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(this.highCardinalityKeyValues);
        }

        @Override
        @NonNull
        public KeyValues getAllKeyValues() {
            return this.getLowCardinalityKeyValues().and((Iterable)this.getHighCardinalityKeyValues());
        }

        public String toString() {
            return "name='" + this.name + '\'' + ", contextualName='" + this.contextualName + '\'' + ", error='" + this.error + '\'' + ", lowCardinalityKeyValues=" + this.toString(this.getLowCardinalityKeyValues()) + ", highCardinalityKeyValues=" + this.toString(this.getHighCardinalityKeyValues()) + ", map=" + this.toString(this.map);
        }

        private String toString(KeyValues keyValues) {
            return keyValues.stream().map(keyValue -> String.format("%s='%s'", keyValue.getKey(), keyValue.getValue())).collect(Collectors.joining(", ", "[", "]"));
        }

        private String toString(Map<Object, Object> map) {
            return map.entrySet().stream().map(entry -> String.format("%s='%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ", "[", "]"));
        }
    }

    public static interface Scope
    extends AutoCloseable {
        public static final Scope NOOP = NoopObservation.NoopScope.INSTANCE;

        public Observation getCurrentObservation();

        @Override
        public void close();

        default public boolean isNoop() {
            return this == NOOP;
        }
    }

    @FunctionalInterface
    public static interface CheckedRunnable<E extends Throwable> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface CheckedCallable<T, E extends Throwable> {
        public T call() throws E;
    }

    public static interface ContextView {
        public String getName();

        @Nullable
        public String getContextualName();

        @Nullable
        public Observation getParentObservation();

        public Optional<Throwable> getError();

        @Nullable
        public <T> T get(Object var1);

        @NonNull
        public <T> T getRequired(Object var1);

        public boolean containsKey(Object var1);

        public <T> T getOrDefault(Object var1, T var2);

        public KeyValues getLowCardinalityKeyValues();

        @NonNull
        public KeyValues getHighCardinalityKeyValues();

        @NonNull
        public KeyValues getAllKeyValues();
    }

    public static interface Event {
        public static Event of(final String name, final String contextualName) {
            return new Event(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getContextualName() {
                    return contextualName;
                }

                public String toString() {
                    return "event.name='" + this.getName() + "', event.contextualName='" + this.getContextualName() + '\'';
                }
            };
        }

        public static Event of(String name) {
            return Event.of(name, name);
        }

        public String getName();

        default public String getContextualName() {
            return this.getName();
        }

        default public Event format(Object ... dynamicEntriesForContextualName) {
            return Event.of(this.getName(), String.format(this.getContextualName(), dynamicEntriesForContextualName));
        }
    }
}

