/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.docs;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Objects;
import java.util.function.Supplier;

public interface DocumentedObservation {
    public static final KeyName[] EMPTY = new KeyName[0];
    public static final Observation.Event[] EMPTY_EVENT_NAMES = new Observation.Event[0];

    @Nullable
    default public String getName() {
        return null;
    }

    default public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
        return null;
    }

    @Nullable
    default public String getContextualName() {
        return null;
    }

    default public KeyName[] getLowCardinalityKeyNames() {
        return EMPTY;
    }

    default public KeyName[] getHighCardinalityKeyNames() {
        return EMPTY;
    }

    default public Observation.Event[] getEvents() {
        return EMPTY_EVENT_NAMES;
    }

    default public String getPrefix() {
        return "";
    }

    default public Observation observation(ObservationRegistry registry) {
        return this.observation(registry, null);
    }

    default public Observation observation(ObservationRegistry registry, @Nullable Observation.Context context) {
        Observation observation = Observation.createNotStarted(this.getName(), context, registry);
        if (this.getContextualName() != null) {
            observation.contextualName(this.getContextualName());
        }
        return observation;
    }

    default public <T extends Observation.Context> Observation observation(@Nullable ObservationConvention<T> customConvention, @NonNull ObservationConvention<T> defaultConvention, @NonNull T context, @NonNull ObservationRegistry registry) {
        if (this.getDefaultConvention() == null) {
            throw new IllegalStateException("You've decided to use convention based naming yet this observation [" + this.getClass() + "] has not defined any default convention");
        }
        if (!this.getDefaultConvention().isAssignableFrom(Objects.requireNonNull(defaultConvention, "You have not provided a default convention in the Observation factory method").getClass())) {
            throw new IllegalArgumentException("Observation [" + this.getClass() + "] defined default convention to be of type [" + this.getDefaultConvention() + "] but you have provided an incompatible one of type [" + defaultConvention.getClass() + "]");
        }
        Observation observation = Observation.createNotStarted(customConvention, defaultConvention, context, registry);
        if (this.getName() != null) {
            context.setName(this.getName());
        }
        if (this.getContextualName() != null) {
            observation.contextualName(this.getContextualName());
        }
        return observation;
    }

    default public <T extends Observation.Context> Observation createNotStarted(@Nullable ObservationConvention<T> customConvention, @NonNull ObservationConvention<T> defaultConvention, @NonNull Supplier<T> contextSupplier, @NonNull ObservationRegistry registry) {
        if (registry.isNoop()) {
            return Observation.NOOP;
        }
        return this.observation(customConvention, defaultConvention, (Observation.Context)contextSupplier.get(), registry);
    }

    default public Observation start(ObservationRegistry registry) {
        return this.start(registry, null);
    }

    default public Observation start(ObservationRegistry registry, @Nullable Observation.Context context) {
        return this.observation(registry, context).start();
    }

    default public <T extends Observation.Context> Observation start(@Nullable ObservationConvention<T> customConvention, @NonNull ObservationConvention<T> defaultConvention, @NonNull T context, @NonNull ObservationRegistry registry) {
        return this.observation(customConvention, defaultConvention, context, registry).start();
    }
}

