/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.internal;

import io.openmessaging.OMSResponseStatus;

public class AccessPointURI {
    private static final String PREFIX = "oms:";
    private final String accessPointString;
    private final String driverType;
    private final String accountId;
    private final String hosts;
    private final String region;
    private static final String PATTERN = "^oms:.+://.+/.+$";

    AccessPointURI(String accessPointString) {
        this.validateAccessPointString(accessPointString);
        this.accessPointString = accessPointString;
        String unprocessedString = accessPointString.substring(PREFIX.length());
        int idx = unprocessedString.indexOf(":");
        this.driverType = unprocessedString.substring(0, idx);
        unprocessedString = unprocessedString.substring(this.driverType.length() + 3);
        idx = unprocessedString.lastIndexOf(47);
        this.region = unprocessedString.substring(idx + 1);
        String userAndHostInformation = unprocessedString.substring(0, idx);
        idx = userAndHostInformation.indexOf(64);
        if (idx > 0) {
            this.accountId = userAndHostInformation.substring(0, idx);
            this.hosts = userAndHostInformation.substring(idx + 1);
        } else {
            this.hosts = userAndHostInformation;
            this.accountId = null;
        }
    }

    public String getAccessPointString() {
        return this.accessPointString;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getRegion() {
        return this.region;
    }

    private void validateAccessPointString(String accessPointString) {
        if (!accessPointString.matches(PATTERN)) {
            throw OMSResponseStatus.generateException(OMSResponseStatus.STATUS_10001, accessPointString);
        }
    }
}

