/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.internal;

import io.openmessaging.KeyValue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultKeyValue
implements KeyValue {
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    @Override
    public KeyValue put(String key, boolean value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public boolean getBoolean(String key) {
        if (!this.properties.containsKey(key)) {
            return false;
        }
        return Boolean.valueOf(this.properties.get(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.properties.containsKey(key) ? this.getBoolean(key) : defaultValue;
    }

    @Override
    public short getShort(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        return Short.valueOf(this.properties.get(key));
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.properties.containsKey(key) ? this.getShort(key) : defaultValue;
    }

    @Override
    public KeyValue put(String key, short value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, int value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, long value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, double value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, String value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public int getInt(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        return Integer.valueOf(this.properties.get(key));
    }

    @Override
    public long getLong(String key) {
        if (!this.properties.containsKey(key)) {
            return 0L;
        }
        return Long.valueOf(this.properties.get(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.properties.containsKey(key) ? this.getLong(key) : defaultValue;
    }

    @Override
    public double getDouble(String key) {
        if (!this.properties.containsKey(key)) {
            return 0.0;
        }
        return Double.valueOf(this.properties.get(key));
    }

    @Override
    public String getString(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }
}

