/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2DatabaseException;
import io.r2dbc.h2.H2Result;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.spi.Batch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.h2.message.DbException;
import reactor.core.publisher.Flux;

public final class H2Batch
implements Batch<H2Batch> {
    private final Client client;
    private final Codecs codecs;
    private final List<String> statements = new ArrayList<String>();

    H2Batch(Client client, Codecs codecs) {
        this.client = Objects.requireNonNull(client, "client must not be null");
        this.codecs = Objects.requireNonNull(codecs, "codecs must not be null");
    }

    public H2Batch add(String sql) {
        Objects.requireNonNull(sql, "sql must not be null");
        this.statements.add(sql);
        return this;
    }

    public Flux<H2Result> execute() {
        return Flux.fromIterable(this.statements).flatMap(statement -> {
            if (Client.INSERT.matcher((CharSequence)statement).matches()) {
                return this.client.update((String)statement, Collections.emptyList()).map(result -> H2Result.toResult(result.getGeneratedKeys(), result.getUpdateCount(), this.codecs));
            }
            return this.client.query((String)statement, Collections.emptyList()).map(result -> H2Result.toResult(result, null, this.codecs));
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }
}

