/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.spi.ColumnMetadata;
import java.util.Objects;
import java.util.Optional;
import org.h2.result.ResultInterface;

public final class H2ColumnMetadata
implements ColumnMetadata {
    private final String name;
    private final Long precision;
    private final Integer type;

    H2ColumnMetadata(String name, Long precision, Integer type) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.precision = Objects.requireNonNull(precision, "precision must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2ColumnMetadata that = (H2ColumnMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.precision, that.precision) && Objects.equals(this.type, that.type);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getPrecision() {
        return Optional.of(this.precision).map(Long::intValue);
    }

    public Integer getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.precision, this.type);
    }

    public String toString() {
        return "H2ColumnMetadata{name='" + this.name + '\'' + ", precision=" + this.precision + ", type=" + this.type + '}';
    }

    static H2ColumnMetadata toColumnMetadata(ResultInterface result, int index) {
        Objects.requireNonNull(result, "result must not be null");
        return new H2ColumnMetadata(result.getColumnName(index), result.getColumnPrecision(index), result.getColumnType(index));
    }
}

