/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2Batch;
import io.r2dbc.h2.H2DatabaseException;
import io.r2dbc.h2.H2Statement;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.IsolationLevel;
import java.util.Objects;
import java.util.function.Function;
import org.h2.message.DbException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class H2Connection
implements Connection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client client;
    private final Codecs codecs;

    H2Connection(Client client, Codecs codecs) {
        this.client = Objects.requireNonNull(client, "client must not be null");
        this.codecs = Objects.requireNonNull(codecs, "codecs must not be null");
    }

    public Mono<Void> beginTransaction() {
        return this.useTransactionStatus(inTransaction -> {
            if (!inTransaction.booleanValue()) {
                return this.client.disableAutoCommit();
            }
            this.logger.debug("Skipping begin transaction because already in one");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public Mono<Void> close() {
        return this.client.close();
    }

    public Mono<Void> commitTransaction() {
        return this.useTransactionStatus(inTransaction -> {
            if (inTransaction.booleanValue()) {
                return this.client.execute("COMMIT").thenEmpty(this.client.enableAutoCommit()).onErrorResume(t -> this.client.enableAutoCommit().then(Mono.error((Throwable)t)));
            }
            this.logger.debug("Skipping commit transaction because no transaction in progress.");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public H2Batch createBatch() {
        return new H2Batch(this.client, this.codecs);
    }

    public Mono<Void> createSavepoint(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return this.useTransactionStatus(inTransaction -> {
            if (inTransaction.booleanValue()) {
                return this.client.execute(String.format("SAVEPOINT %s", name));
            }
            this.logger.debug("Skipping savepoint because no transaction in progress.");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public H2Statement createStatement(String sql) {
        return new H2Statement(this.client, this.codecs, sql);
    }

    public Mono<Void> releaseSavepoint(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return this.useTransactionStatus(inTransaction -> {
            if (inTransaction.booleanValue()) {
                return this.client.execute(String.format("RELEASE SAVEPOINT %s", name));
            }
            this.logger.debug("Skipping release savepoint because no transaction in progress.");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public Mono<Void> rollbackTransaction() {
        return this.useTransactionStatus(inTransaction -> {
            if (inTransaction.booleanValue()) {
                return this.client.execute("ROLLBACK").thenEmpty(this.client.enableAutoCommit()).onErrorResume(t -> this.client.enableAutoCommit().then(Mono.error((Throwable)t)));
            }
            this.logger.debug("Skipping rollback because no transaction in progress.");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return this.useTransactionStatus(inTransaction -> {
            if (inTransaction.booleanValue()) {
                return this.client.execute(String.format("ROLLBACK TO SAVEPOINT %s", name));
            }
            this.logger.debug("Skipping rollback to savepoint because no transaction in progress.");
            return Mono.empty();
        }).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        Objects.requireNonNull(isolationLevel, "isolationLevel must not be null");
        return this.client.execute(H2Connection.getTransactionIsolationLevelQuery(isolationLevel)).onErrorMap(DbException.class, H2DatabaseException::new);
    }

    private static String getTransactionIsolationLevelQuery(IsolationLevel isolationLevel) {
        if (IsolationLevel.READ_COMMITTED == isolationLevel) {
            return String.format("SET LOCK_MODE %d", 3);
        }
        if (IsolationLevel.READ_UNCOMMITTED == isolationLevel) {
            return String.format("SET LOCK_MODE %d", 0);
        }
        if (IsolationLevel.REPEATABLE_READ == isolationLevel || IsolationLevel.SERIALIZABLE == isolationLevel) {
            return String.format("SET LOCK_MODE %d", 1);
        }
        throw new IllegalArgumentException(String.format("Invalid isolation level %s", isolationLevel));
    }

    private Mono<Void> useTransactionStatus(Function<Boolean, Publisher<?>> f) {
        return Flux.defer(() -> (Publisher)f.apply(this.client.inTransaction())).then();
    }
}

