/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public final class H2ConnectionConfiguration {
    private final String password;
    private final String url;
    private final String username;

    private H2ConnectionConfiguration(@Nullable String password, String url, @Nullable String username) {
        this.password = password;
        this.url = Objects.requireNonNull(url, "url must not be null");
        this.username = username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "H2ConnectionConfiguration{password='" + this.password + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + '}';
    }

    Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    String getUrl() {
        return this.url;
    }

    Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public static final class Builder {
        private String password;
        private String url;
        private String username;

        public H2ConnectionConfiguration build() {
            return new H2ConnectionConfiguration(this.password, this.url, this.username);
        }

        public Builder file(String path) {
            return this.url(String.format("file:%s", path));
        }

        public Builder inMemory(String name) {
            return this.url(String.format("mem:%s", name));
        }

        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public String toString() {
            return "Builder{password='" + this.password + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + '}';
        }

        public Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }
    }
}

