/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2Connection;
import io.r2dbc.h2.H2ConnectionConfiguration;
import io.r2dbc.h2.H2ConnectionFactoryMetadata;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.client.SessionClient;
import io.r2dbc.h2.codecs.DefaultCodecs;
import io.r2dbc.spi.ConnectionFactory;
import java.util.Objects;
import java.util.Properties;
import org.h2.engine.ConnectionInfo;
import reactor.core.publisher.Mono;

public final class H2ConnectionFactory
implements ConnectionFactory {
    private final Mono<? extends Client> clientFactory;

    public H2ConnectionFactory(H2ConnectionConfiguration configuration) {
        this((Mono<? extends Client>)Mono.defer(() -> {
            Objects.requireNonNull(configuration, "configuration must not be null");
            return Mono.just((Object)new SessionClient(H2ConnectionFactory.getConnectionInfo(configuration)));
        }));
    }

    H2ConnectionFactory(Mono<? extends Client> clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory must not be null");
    }

    public Mono<H2Connection> create() {
        return this.clientFactory.map(client -> new H2Connection((Client)client, new DefaultCodecs()));
    }

    public H2ConnectionFactoryMetadata getMetadata() {
        return H2ConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        return "H2ConnectionFactory{clientFactory=" + this.clientFactory + '}';
    }

    private static ConnectionInfo getConnectionInfo(H2ConnectionConfiguration configuration) {
        StringBuilder sb = new StringBuilder("jdbc:h2:").append(configuration.getUrl());
        configuration.getUsername().ifPresent(username -> sb.append(";USER=").append((String)username));
        configuration.getPassword().ifPresent(password -> sb.append(";PASSWORD=").append((String)password));
        return new ConnectionInfo(sb.toString(), new Properties());
    }
}

