/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2DatabaseException;
import io.r2dbc.h2.H2Row;
import io.r2dbc.h2.H2RowMetadata;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Objects;
import java.util.function.BiFunction;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;
import reactor.util.annotation.Nullable;

public final class H2Result
implements Result {
    private final Mono<H2RowMetadata> rowMetadata;
    private final Flux<H2Row> rows;
    private final Mono<Integer> rowsUpdated;

    H2Result(Mono<H2RowMetadata> rowMetadata, Flux<H2Row> rows, Mono<Integer> rowsUpdated) {
        this.rowMetadata = Objects.requireNonNull(rowMetadata, "rowMetadata must not be null");
        this.rows = Objects.requireNonNull(rows, "rows must not be null");
        this.rowsUpdated = Objects.requireNonNull(rowsUpdated, "rowsUpdated must not be null");
    }

    public Mono<Integer> getRowsUpdated() {
        return this.rowsUpdated;
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Objects.requireNonNull(f, "f must not be null");
        return this.rows.zipWith((Publisher)this.rowMetadata.repeat()).map(TupleUtils.function(f::apply));
    }

    public String toString() {
        return "H2Result{, rowMetadata=" + this.rowMetadata + ", rows=" + this.rows + ", rowsUpdated=" + this.rowsUpdated + '}';
    }

    static H2Result toResult(ResultInterface result, @Nullable Integer rowsUpdated, Codecs codecs) {
        Objects.requireNonNull(result, "result must not be null");
        Objects.requireNonNull(codecs, "codecs must not be null");
        Mono rowMetadata = Mono.just((Object)H2RowMetadata.toRowMetadata(result));
        Flux rows = Flux.generate(sink -> {
            if (result.next()) {
                sink.next((Object)result.currentRow());
            } else {
                result.close();
                sink.complete();
            }
        }).map(values -> H2Row.toRow(values, result, codecs)).onErrorMap(DbException.class, H2DatabaseException::new);
        return new H2Result((Mono<H2RowMetadata>)rowMetadata, (Flux<H2Row>)rows, (Mono<Integer>)Mono.justOrEmpty((Object)rowsUpdated));
    }
}

