/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.spi.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import reactor.util.annotation.Nullable;

public final class H2Row
implements Row {
    private final Codecs codecs;
    private final List<Column> columns;
    private final Map<String, Column> nameKeyedColumns;

    H2Row(List<Column> columns, Codecs codecs) {
        this.columns = Objects.requireNonNull(columns, "columns must not be null");
        this.codecs = Objects.requireNonNull(codecs, "codecs must not be null");
        this.nameKeyedColumns = this.getNameKeyedColumns(this.columns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2Row that = (H2Row)o;
        return Objects.equals(this.columns, that.columns);
    }

    @Nullable
    public <T> T get(Object identifier, Class<T> type) {
        Column column;
        Objects.requireNonNull(identifier, "identifier must not be null");
        Objects.requireNonNull(type, "type must not be null");
        if (identifier instanceof Integer) {
            column = this.getColumn((Integer)identifier);
        } else if (identifier instanceof String) {
            column = this.getColumn((String)identifier);
        } else {
            throw new IllegalArgumentException(String.format("Identifier '%s' is not a valid identifier. Should either be an Integer index or a String column name.", identifier));
        }
        return this.codecs.decode(column.getValue(), column.getDataType(), type);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public String toString() {
        return "H2Row{columns=" + this.columns + ", nameKeyedColumns=" + this.nameKeyedColumns + '}';
    }

    static H2Row toRow(Value[] values, ResultInterface result, Codecs codecs) {
        Objects.requireNonNull(values, "values must not be null");
        Objects.requireNonNull(result, "result must not be null");
        Objects.requireNonNull(codecs, "codecs must not null");
        List<Column> columns = H2Row.getColumns(values, result);
        return new H2Row(columns, codecs);
    }

    private static List<Column> getColumns(Value[] values, ResultInterface result) {
        ArrayList<Column> columns = new ArrayList<Column>(values.length);
        for (int i = 0; i < values.length; ++i) {
            columns.add(new Column(result.getColumnType(i), result.getColumnName(i).toUpperCase(), values[i]));
        }
        return columns;
    }

    private Column getColumn(String name) {
        String normalized = name.toUpperCase();
        if (!this.nameKeyedColumns.containsKey(normalized)) {
            throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", normalized, this.nameKeyedColumns.keySet()));
        }
        return this.nameKeyedColumns.get(normalized);
    }

    private Column getColumn(Integer index) {
        if (index >= this.columns.size()) {
            throw new IllegalArgumentException(String.format("Column index %d is larger than the number of columns %d", index, this.columns.size()));
        }
        return this.columns.get(index);
    }

    private Map<String, Column> getNameKeyedColumns(List<Column> columns) {
        HashMap<String, Column> nameKeyedColumns = new HashMap<String, Column>(columns.size());
        for (Column column : columns) {
            nameKeyedColumns.put(column.getName(), column);
        }
        return nameKeyedColumns;
    }

    static final class Column {
        private final Integer dataType;
        private final String name;
        private final Value value;

        Column(Integer dataType, String name, Value value) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            this.name = Objects.requireNonNull(name, "name must not be null");
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column that = (Column)o;
            return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.dataType, this.name, this.value);
        }

        public String toString() {
            return "Column{dataType=" + this.dataType + ", name='" + this.name + '\'' + ", value=" + this.value + '}';
        }

        private Integer getDataType() {
            return this.dataType;
        }

        private String getName() {
            return this.name;
        }

        private Value getValue() {
            return this.value;
        }
    }
}

