/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2ColumnMetadata;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.h2.result.ResultInterface;

public final class H2RowMetadata
implements RowMetadata {
    private final List<H2ColumnMetadata> columnMetadatas;
    private final Map<String, H2ColumnMetadata> nameKeyedColumnMetadatas;

    H2RowMetadata(List<H2ColumnMetadata> columnMetadatas) {
        this.columnMetadatas = Objects.requireNonNull(columnMetadatas, "columnMetadatas must not be null");
        this.nameKeyedColumnMetadatas = this.getNameKeyedColumnMetadatas(columnMetadatas);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2RowMetadata that = (H2RowMetadata)o;
        return Objects.equals(this.columnMetadatas, that.columnMetadatas);
    }

    public ColumnMetadata getColumnMetadata(Object identifier) {
        Objects.requireNonNull(identifier, "identifier must not be null");
        if (identifier instanceof Integer) {
            return this.getColumnMetadata((Integer)identifier);
        }
        if (identifier instanceof String) {
            return this.getColumnMetadata((String)identifier);
        }
        throw new IllegalArgumentException(String.format("Identifier '%s' is not a valid identifier. Should either be an Integer index or a String column name.", identifier));
    }

    public List<H2ColumnMetadata> getColumnMetadatas() {
        return Collections.unmodifiableList(this.columnMetadatas);
    }

    public int hashCode() {
        return Objects.hash(this.columnMetadatas);
    }

    public String toString() {
        return "H2RowMetadata{columnMetadatas=" + this.columnMetadatas + ", nameKeyedColumnMetadatas=" + this.nameKeyedColumnMetadatas + '}';
    }

    static H2RowMetadata toRowMetadata(ResultInterface result) {
        Objects.requireNonNull(result, "result must not be null");
        return new H2RowMetadata(H2RowMetadata.getColumnMetadatas(result));
    }

    private static List<H2ColumnMetadata> getColumnMetadatas(ResultInterface result) {
        ArrayList<H2ColumnMetadata> columnMetadatas = new ArrayList<H2ColumnMetadata>(result.getVisibleColumnCount());
        for (int i = 0; i < result.getVisibleColumnCount(); ++i) {
            columnMetadatas.add(H2ColumnMetadata.toColumnMetadata(result, i));
        }
        return columnMetadatas;
    }

    private ColumnMetadata getColumnMetadata(Integer index) {
        if (index >= this.columnMetadatas.size()) {
            throw new IllegalArgumentException(String.format("Column index %d is larger than the number of columns %d", index, this.columnMetadatas.size()));
        }
        return this.columnMetadatas.get(index);
    }

    private ColumnMetadata getColumnMetadata(String name) {
        if (!this.nameKeyedColumnMetadatas.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", name, this.nameKeyedColumnMetadatas.keySet()));
        }
        return this.nameKeyedColumnMetadatas.get(name);
    }

    private Map<String, H2ColumnMetadata> getNameKeyedColumnMetadatas(List<H2ColumnMetadata> columnMetadatas) {
        HashMap<String, H2ColumnMetadata> nameKeyedColumnMetadatas = new HashMap<String, H2ColumnMetadata>(columnMetadatas.size());
        for (H2ColumnMetadata columnMetadata : columnMetadatas) {
            nameKeyedColumnMetadatas.put(columnMetadata.getName(), columnMetadata);
        }
        return nameKeyedColumnMetadatas;
    }
}

