/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.client;

import io.r2dbc.h2.client.Binding;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Client {
    public static final Pattern INSERT = Pattern.compile(".*INSERT.*", 2);
    public static final Pattern SELECT = Pattern.compile(".*SELECT.*", 2);

    public Mono<Void> close();

    public Mono<Void> disableAutoCommit();

    public Mono<Void> enableAutoCommit();

    default public Mono<Void> execute(String sql) {
        Objects.requireNonNull(sql, "sql must not be null");
        return this.update(sql, Collections.emptyList()).then();
    }

    public boolean inTransaction();

    public Flux<ResultInterface> query(String var1, List<Binding> var2);

    public Flux<ResultWithGeneratedKeys> update(String var1, List<Binding> var2);
}

