/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.client;

import io.r2dbc.h2.client.Binding;
import io.r2dbc.h2.client.Client;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.h2.command.CommandInterface;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SessionClient
implements Client {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionInterface session;

    public SessionClient(ConnectionInfo connectionInfo) {
        Objects.requireNonNull(connectionInfo, "connectionInfo must not be null");
        this.session = new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
    }

    @Override
    public Mono<Void> close() {
        return Mono.defer(() -> {
            this.session.close();
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> disableAutoCommit() {
        return Mono.defer(() -> {
            this.session.setAutoCommit(false);
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> enableAutoCommit() {
        return Mono.defer(() -> {
            this.session.setAutoCommit(true);
            return Mono.empty();
        });
    }

    @Override
    public boolean inTransaction() {
        return !this.session.getAutoCommit();
    }

    @Override
    public Flux<ResultInterface> query(String sql, List<Binding> bindings) {
        Objects.requireNonNull(sql, "sql must not be null");
        Objects.requireNonNull(bindings, "bindings must not be null");
        return Flux.fromIterable(bindings).defaultIfEmpty((Object)Binding.EMPTY).map(binding -> this.createCommand(sql, (Binding)binding)).doOnNext(command -> this.logger.debug("Request:  {}", command)).flatMap(command -> Mono.just((Object)command.executeQuery(Integer.MAX_VALUE, false))).doOnNext(result -> this.logger.debug("Response: {}", result));
    }

    @Override
    public Flux<ResultWithGeneratedKeys> update(String sql, List<Binding> bindings) {
        Objects.requireNonNull(sql, "sql must not be null");
        Objects.requireNonNull(bindings, "bindings must not be null");
        return Flux.fromIterable(bindings).defaultIfEmpty((Object)Binding.EMPTY).map(binding -> this.createCommand(sql, (Binding)binding)).doOnNext(command -> this.logger.debug("Request: {}", command)).flatMap(command -> Mono.just((Object)command.executeUpdate((Object)true)));
    }

    private CommandInterface createCommand(String sql, Binding binding) {
        CommandInterface command = this.session.prepareCommand(sql, Integer.MAX_VALUE);
        ArrayList parameters = command.getParameters();
        for (Map.Entry<Integer, Value> entry : binding.getParameters().entrySet()) {
            ((ParameterInterface)parameters.get(entry.getKey())).setValue(entry.getValue(), false);
        }
        return command;
    }
}

