/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.BigDecimalCodec;
import io.r2dbc.h2.codecs.BooleanCodec;
import io.r2dbc.h2.codecs.ByteCodec;
import io.r2dbc.h2.codecs.BytesCodec;
import io.r2dbc.h2.codecs.Codec;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.codecs.DateCodec;
import io.r2dbc.h2.codecs.DoubleCodec;
import io.r2dbc.h2.codecs.FloatCodec;
import io.r2dbc.h2.codecs.IntegerCodec;
import io.r2dbc.h2.codecs.LongCodec;
import io.r2dbc.h2.codecs.ShortCodec;
import io.r2dbc.h2.codecs.StringCodec;
import io.r2dbc.h2.codecs.TimeCodec;
import io.r2dbc.h2.codecs.TimestampCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.h2.value.Value;
import reactor.util.annotation.Nullable;

public final class DefaultCodecs
implements Codecs {
    private final List<Codec<?>> codecs = Arrays.asList(new BigDecimalCodec(), new BooleanCodec(), new ByteCodec(), new BytesCodec(), new DateCodec(), new DoubleCodec(), new FloatCodec(), new IntegerCodec(), new LongCodec(), new ShortCodec(), new StringCodec(), new TimeCodec(), new TimestampCodec());

    @Override
    @Nullable
    public <T> T decode(Value value, int dataType, Class<? extends T> type) {
        Objects.requireNonNull(type, "type must not be null");
        if (value == null) {
            return null;
        }
        for (Codec<T> codec : this.codecs) {
            if (!codec.canDecode(dataType, type)) continue;
            return (T)codec.decode(value, type);
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s", type.getName()));
    }

    @Override
    public Value encode(Object value) {
        Objects.requireNonNull(value, "value must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(value);
        }
        throw new IllegalArgumentException(String.format("Cannot encode parameter of type %s", value.getClass().getName()));
    }

    @Override
    public Value encodeNull(Class<?> type) {
        Objects.requireNonNull(type, "type must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncodeNull(type)) continue;
            return codec.encodeNull();
        }
        throw new IllegalArgumentException(String.format("Cannot encode null parameter of type %s", type.getName()));
    }
}

