/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import java.util.Objects;
import org.h2.value.Value;
import org.h2.value.ValueLong;

final class LongCodec
extends AbstractCodec<Long> {
    LongCodec() {
        super(Long.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 5;
    }

    @Override
    Long doDecode(Value value, Class<? extends Long> type) {
        return value.getLong();
    }

    @Override
    Value doEncode(Long value) {
        return ValueLong.get((long)Objects.requireNonNull(value, "value must not be null"));
    }
}

