/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import java.util.Objects;
import org.h2.value.Value;
import org.h2.value.ValueString;

final class StringCodec
extends AbstractCodec<String> {
    StringCodec() {
        super(String.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return 13 == dataType || 21 == dataType || 14 == dataType;
    }

    @Override
    String doDecode(Value value, Class<? extends String> type) {
        return value.getString();
    }

    @Override
    Value doEncode(String value) {
        return ValueString.get((String)Objects.requireNonNull(value, "value must not be null"));
    }
}

