/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import java.sql.Timestamp;
import java.util.Objects;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

final class TimestampCodec
extends AbstractCodec<Timestamp> {
    TimestampCodec() {
        super(Timestamp.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 11;
    }

    @Override
    Timestamp doDecode(Value value, Class<? extends Timestamp> type) {
        return value.getTimestamp();
    }

    @Override
    Value doEncode(Timestamp value) {
        return ValueTimestamp.get((Timestamp)Objects.requireNonNull(value, "value must not be null"));
    }
}

