/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.seata.common.exception.NotSupportYetException;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration<Listener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
    private static final String SEATA_GROUP = "SEATA_GROUP";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String REGISTRY_TYPE = "nacos";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static volatile ConfigService configService;

    public NacosConfiguration() throws NacosException {
        if (null == configService) {
            configService = NacosFactory.createConfigService((Properties)NacosConfiguration.getConfigProperties());
        }
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value;
        try {
            value = configService.getConfig(dataId, SEATA_GROUP, timeoutMills);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
            value = defaultValue;
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.publishConfig(dataId, SEATA_GROUP, content);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.removeConfig(dataId, SEATA_GROUP);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public void addConfigListener(String dataId, Listener listener) {
        try {
            configService.addListener(dataId, SEATA_GROUP, listener);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
    }

    @Override
    public void removeConfigListener(String dataId, Listener listener) {
        configService.removeListener(dataId, SEATA_GROUP, listener);
    }

    @Override
    public List<Listener> getConfigListeners(String dataId) {
        throw new NotSupportYetException("not support getConfigListeners");
    }

    private static Properties getConfigProperties() {
        Properties properties = new Properties();
        if (null != System.getProperty(PRO_SERVER_ADDR_KEY)) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (null != address) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        return properties;
    }

    private static String getNacosAddrFileKey() {
        return "registry.nacos.serverAddr";
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }
}

