/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.jdbc.core.statement;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.jdbc.adapter.AbstractStatementAdapter;
import io.shardingjdbc.core.jdbc.core.connection.MasterSlaveConnection;
import io.shardingjdbc.core.parsing.SQLJudgeEngine;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;

public final class MasterSlaveStatement
extends AbstractStatementAdapter {
    private final MasterSlaveConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();

    public MasterSlaveStatement(MasterSlaveConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public MasterSlaveStatement(MasterSlaveConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public MasterSlaveStatement(MasterSlaveConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        Collection<Connection> connections = this.connection.getConnections(sqlStatement.getType());
        Preconditions.checkState((1 == connections.size() ? 1 : 0) != 0, (Object)"Cannot support executeQuery for DDL");
        Statement statement = connections.iterator().next().createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.routedStatements.add(statement);
        return statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int result = 0;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int result = 0;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, autoGeneratedKeys);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int result = 0;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, columnIndexes);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int result = 0;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result += statement.executeUpdate(sql, columnNames);
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result = false;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, autoGeneratedKeys);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result = false;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, columnIndexes);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result = false;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : this.connection.getConnections(sqlStatement.getType())) {
            Statement statement = each.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.routedStatements.add(statement);
            result = statement.execute(sql, columnNames);
        }
        return result;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getGeneratedKeys();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getResultSet();
    }

    @Override
    public MasterSlaveConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }
}

