/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.ExpressionClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingjdbc.core.parsing.parser.token.TableToken;
import io.shardingjdbc.core.util.SQLUtil;

public final class UpdateSetItemsClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final ExpressionClauseParser expressionClauseParser;

    public UpdateSetItemsClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(DMLStatement updateStatement) {
        this.lexerEngine.accept(DefaultKeyword.SET);
        do {
            this.parseSetItem(updateStatement);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    private void parseSetItem(DMLStatement updateStatement) {
        this.parseSetColumn(updateStatement);
        this.lexerEngine.skipIfEqual(Symbol.EQ, Symbol.COLON_EQ);
        this.parseSetValue(updateStatement);
    }

    private void parseSetColumn(DMLStatement updateStatement) {
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(updateStatement);
            return;
        }
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            if (updateStatement.getTables().getSingleTableName().equalsIgnoreCase(SQLUtil.getExactlyValue(literals))) {
                updateStatement.getSqlTokens().add(new TableToken(beginPosition - literals.length(), literals));
            }
            this.lexerEngine.nextToken();
        }
    }

    private void parseSetValue(DMLStatement updateStatement) {
        this.expressionClauseParser.parse(updateStatement);
    }
}

