/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect.mysql.sql;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.clause.MySQLLimitClauseParser;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.clause.MySQLSelectOptionClauseParser;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.clause.facade.MySQLSelectClauseParserFacade;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.rule.ShardingRule;

public final class MySQLSelectParser
extends AbstractSelectParser {
    private final MySQLSelectOptionClauseParser selectOptionClauseParser;
    private final MySQLLimitClauseParser limitClauseParser;

    public MySQLSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine, new MySQLSelectClauseParserFacade(shardingRule, lexerEngine));
        this.selectOptionClauseParser = new MySQLSelectOptionClauseParser(lexerEngine);
        this.limitClauseParser = new MySQLLimitClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseDistinct();
        this.parseSelectOption();
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseOrderBy(selectStatement);
        this.parseLimit(selectStatement);
        this.parseSelectRest();
    }

    private void parseSelectOption() {
        this.selectOptionClauseParser.parse();
    }

    private void parseLimit(SelectStatement selectStatement) {
        this.limitClauseParser.parse(selectStatement);
    }
}

