/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.LocalTracer;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

final class TracedSpanStore
implements SpanStore {
    private final LocalTracer tracer;
    private final SpanStore delegate;
    private final String component;

    TracedSpanStore(LocalTracer tracer, StorageComponent component) {
        this.tracer = tracer;
        this.delegate = component.spanStore();
        this.component = component.getClass().getSimpleName();
    }

    public List<List<Span>> getTraces(QueryRequest request) {
        if (this.tracer.startNewSpan(this.component, "get-traces") != null) {
            this.tracer.submitBinaryAnnotation("request", request.toString());
        }
        try {
            List list = this.delegate.getTraces(request);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        this.tracer.startNewSpan(this.component, "get-trace");
        try {
            List list = this.delegate.getTrace(traceIdHigh, traceIdLow);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        this.tracer.startNewSpan(this.component, "get-raw-trace");
        try {
            List list = this.delegate.getRawTrace(traceIdHigh, traceIdLow);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getServiceNames() {
        this.tracer.startNewSpan(this.component, "get-service-names");
        try {
            List list = this.delegate.getServiceNames();
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    public List<String> getSpanNames(String serviceName) {
        this.tracer.startNewSpan(this.component, "get-span-names");
        try {
            List list = this.delegate.getSpanNames(serviceName);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        this.tracer.startNewSpan(this.component, "get-dependencies");
        try {
            List list = this.delegate.getDependencies(endTs, lookback);
            return list;
        }
        finally {
            this.tracer.finishSpan();
        }
    }
}

