/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import brave.Tracer;
import brave.Tracing;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

final class TracingSpanStore
implements SpanStore {
    private final Tracer tracer;
    private final SpanStore delegate;

    TracingSpanStore(Tracing tracing, StorageComponent component) {
        this.tracer = tracing.tracer();
        this.delegate = component.spanStore();
    }

    /*
     * Loose catch block
     */
    public List<List<Span>> getTraces(QueryRequest request) {
        brave.Span span = this.tracer.nextSpan().name("get-traces").tag("request", request.toString());
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getTraces(request);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    public List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    /*
     * Loose catch block
     */
    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        brave.Span span = this.tracer.nextSpan().name("get-trace");
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getTrace(traceIdHigh, traceIdLow);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    /*
     * Loose catch block
     */
    public List<Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        brave.Span span = this.tracer.nextSpan().name("get-raw-trace");
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getRawTrace(traceIdHigh, traceIdLow);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    /*
     * Loose catch block
     */
    public List<String> getServiceNames() {
        brave.Span span = this.tracer.nextSpan().name("get-service-names");
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getServiceNames();
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    /*
     * Loose catch block
     */
    public List<String> getSpanNames(String serviceName) {
        brave.Span span = this.tracer.nextSpan().name("get-span-names");
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getSpanNames(serviceName);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    /*
     * Loose catch block
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        brave.Span span = this.tracer.nextSpan().name("get-dependencies");
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                List list = this.delegate.getDependencies(endTs, lookback);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }
}

