/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.util.HashSet;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumns;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsDescriptor
extends MetadataDescriptor {
    private HashSet<NamedQuery> m_namedQueries;
    private HashSet<NamedNativeQuery> m_namedNativeQueries;

    public AnnotationsDescriptor(Class javaClass) {
        super(javaClass);
        this.init();
    }

    public AnnotationsDescriptor(ClassDescriptor descriptor, Class javaClass) {
        super(descriptor, javaClass);
        this.init();
    }

    public AnnotationsDescriptor(MetadataDescriptor descriptor) {
        super(descriptor);
        this.init();
    }

    public void addNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.m_namedNativeQueries.add(namedNativeQuery);
    }

    public void addNamedQuery(NamedQuery namedQuery) {
        this.m_namedQueries.add(namedQuery);
    }

    @Override
    public String getDiscriminatorValue() {
        DiscriminatorValue discriminatorValue = (DiscriminatorValue)AnnotationsHelper.getAnnotation(DiscriminatorValue.class, this);
        if (discriminatorValue == null) {
            return null;
        }
        return discriminatorValue.value();
    }

    public HashSet<NamedNativeQuery> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public HashSet<NamedQuery> getNamedQueries() {
        return this.m_namedQueries;
    }

    @Override
    protected boolean hasEntityTag(Class cls) {
        return cls.isAnnotationPresent(Entity.class);
    }

    @Override
    protected boolean hasInheritanceTag(Class entityClass) {
        return entityClass.isAnnotationPresent(Inheritance.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.m_javaClass.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }

    private void init() {
        this.m_namedQueries = new HashSet();
        this.m_namedNativeQueries = new HashSet();
    }

    public void setInheritanceStrategy(InheritanceType inheritanceStrategy) {
        if (inheritanceStrategy == InheritanceType.TABLE_PER_CLASS) {
            throw ValidationException.tablePerClassInheritanceNotSupported(this.m_javaClass);
        }
        this.m_usesSingleTableInheritanceStrategy = inheritanceStrategy == InheritanceType.SINGLE_TABLE;
    }
}

