/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsHelper
extends MetadataHelper {
    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataAccessor accessor) {
        return AnnotationsHelper.getAnnotation(annotation, accessor.getAnnotatedElement(), accessor.getMetadataDescriptor());
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(annotation);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return null;
        }
        return AnnotationsHelper.getAnnotation(annotation, annotatedElement);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataDescriptor descriptor) {
        return AnnotationsHelper.getAnnotation(annotation, descriptor.getJavaClass(), descriptor);
    }

    protected static int getDeclaredAnnotationsCount(AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return 0;
        }
        return annotatedElement.getDeclaredAnnotations().length;
    }

    public static boolean isAnnotationNotPresent(Class annotation, AnnotatedElement annotatedElement) {
        return !annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return false;
        }
        return AnnotationsHelper.isAnnotationPresent(annotation, annotatedElement);
    }

    public static boolean isAnnotationPresent(Class annotation, MetadataDescriptor descriptor) {
        return AnnotationsHelper.isAnnotationPresent(annotation, descriptor.getJavaClass(), descriptor);
    }

    public static boolean isEmbedded(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor) {
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (AnnotationsHelper.isAnnotationNotPresent(Embedded.class, annotatedElement) && AnnotationsHelper.isAnnotationNotPresent(EmbeddedId.class, annotatedElement)) {
            return AnnotationsHelper.isAnnotationPresent(Embeddable.class, accessibleObject.getReferenceClass());
        }
        return AnnotationsHelper.isAnnotationPresent(Embedded.class, annotatedElement, descriptor);
    }

    public static boolean isManyToMany(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor) {
        Class rawClass = accessibleObject.getRawClass();
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (AnnotationsHelper.isAnnotationPresent(ManyToMany.class, annotatedElement, descriptor)) {
            if (MetadataHelper.isSupportedCollectionClass(rawClass)) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(rawClass, annotatedElement);
        }
        return false;
    }

    public static boolean isManyToOne(MetadataAccessibleObject annotatedAccessor, MetadataDescriptor descriptor) {
        return AnnotationsHelper.isAnnotationPresent(ManyToOne.class, annotatedAccessor.getAnnotatedElement(), descriptor);
    }

    public static boolean isOneToMany(MetadataAccessibleObject annotatedAccessor, MetadataLogger logger, MetadataDescriptor descriptor) {
        Class rawClass = annotatedAccessor.getRawClass();
        AnnotatedElement annotatedElement = annotatedAccessor.getAnnotatedElement();
        if (AnnotationsHelper.isAnnotationNotPresent(OneToMany.class, annotatedElement)) {
            if (MetadataHelper.isGenericCollectionType(annotatedAccessor.getRelationType()) && MetadataHelper.isSupportedCollectionClass(rawClass)) {
                logger.logConfigMessage("metadata_default_one_to_many_mapping", annotatedElement);
                return true;
            }
        } else if (AnnotationsHelper.isAnnotationPresent(OneToMany.class, annotatedElement, descriptor)) {
            if (MetadataHelper.isSupportedCollectionClass(rawClass)) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(rawClass, annotatedElement);
        }
        return false;
    }

    public static boolean isOneToOne(MetadataAccessibleObject accessibleObject, HashMap m_descriptors, MetadataLogger logger, MetadataDescriptor descriptor) {
        Class referenceClass = accessibleObject.getReferenceClass();
        AnnotatedElement annotatedElement = accessibleObject.getAnnotatedElement();
        if (AnnotationsHelper.isAnnotationNotPresent(OneToOne.class, annotatedElement)) {
            if (m_descriptors.containsKey(referenceClass) && !AnnotationsHelper.isEmbedded(accessibleObject, descriptor)) {
                logger.logConfigMessage("metadata_default_one_to_one_mapping", annotatedElement);
                return true;
            }
            return false;
        }
        return AnnotationsHelper.isAnnotationPresent(OneToOne.class, annotatedElement, descriptor);
    }

    public static boolean shouldIgnoreAnnotations(Class cls, HashMap<Class, AnnotationsDescriptor> metadataDescriptors) {
        AnnotationsDescriptor descriptor = metadataDescriptors.get(cls);
        if (descriptor != null) {
            return descriptor.shouldIgnoreAnnotations();
        }
        return false;
    }
}

