/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.AnnotationsAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.EmbeddedAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.ManyToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.ManyToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.OneToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.accessors.OneToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.columns.AnnotationsColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.sequencing.AnnotationsGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.sequencing.AnnotationsSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.sequencing.AnnotationsTableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.base.QueryHintsHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataField;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataMethod;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.ColumnResult;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.queryframework.EntityResult;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotationsProcessor
extends MetadataProcessor {
    private Collection<Class> m_classes;
    private HashSet<AnnotationsDescriptor> m_entitiesWithQueries;

    public EJBAnnotationsProcessor(AbstractSession session, ClassLoader loader, Collection<Class> classes, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_classes = classes;
        this.m_session = session;
        this.m_metadataDescriptors = new HashMap();
        this.m_validator = new AnnotationsValidator();
        this.m_metadataProject = new MetadataProject();
        this.m_logger = new AnnotationsLogger(this.m_session);
        this.m_enableLazyForOneToOne = enableLazyForOneToOne;
        this.m_relatedEntities = new HashSet();
        this.m_entitiesWithQueries = new HashSet();
    }

    public EJBAnnotationsProcessor(AbstractSession session, ClassLoader loader, boolean enableLazyForOneToOne, HashMap<Class, MetadataDescriptor> metadataDescriptors, MetadataProject metadataProject) {
        this(session, loader, metadataDescriptors.keySet(), enableLazyForOneToOne);
        this.m_metadataProject = metadataProject;
        if (metadataDescriptors != null && !metadataDescriptors.isEmpty()) {
            for (MetadataDescriptor mdd : metadataDescriptors.values()) {
                AnnotationsDescriptor descriptor = new AnnotationsDescriptor(mdd);
                this.m_metadataDescriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
    }

    public void addEntityListeners(AbstractSession session, Collection<Class> entityClasses) {
        this.updateClassesInMetadata();
        for (Class entityClass : entityClasses) {
            AnnotationsDescriptor descriptor = (AnnotationsDescriptor)this.m_metadataDescriptors.get(entityClass);
            this.processExcludeDefaultListeners(descriptor);
            this.processExcludeSuperclassListeners(descriptor);
            this.processDefaultListeners(descriptor);
            this.processEntityListeners(descriptor);
            this.processEntityEventListener(descriptor);
        }
    }

    public void addNamedQueriesToSession(AbstractSession session) {
        for (AnnotationsDescriptor descriptor : this.m_entitiesWithQueries) {
            for (NamedQuery namedQuery : descriptor.getNamedQueries()) {
                this.processNamedQuery(namedQuery, descriptor, session);
            }
            for (NamedNativeQuery namedNativeQuery : descriptor.getNamedNativeQueries()) {
                this.processNamedNativeQuery(namedNativeQuery, descriptor, session);
            }
        }
    }

    protected void adjustPrimaryKeyNameOnExistingFields(MetadataDescriptor md) {
        ArrayList pkFields = (ArrayList)md.getPrimaryKeyFields();
        if (pkFields.size() <= 1) {
            this.getValidator().throwNoPrimaryKeyAnnotationsFound(md.getJavaClass());
        }
        if (pkFields.size() > 2) {
            this.getValidator().throwUnspecifiedCompositePrimaryKeyNotSupported(md.getJavaClass());
        }
        DatabaseField validPKField = (DatabaseField)pkFields.get(1);
        pkFields.remove(0);
        for (DatabaseField dbField : md.getFieldsWithDefaultPrimaryKeySet()) {
            dbField.setName(validPKField.getName());
        }
        for (DatabaseField dbField : md.getFieldsWithComplexDefaultPrimaryKeySet()) {
            String defaultFieldName = dbField.getName();
            String validFieldName = defaultFieldName.substring(0, defaultFieldName.lastIndexOf("_") + 1) + validPKField.getName();
            dbField.setName(validFieldName);
        }
    }

    protected AnnotationsAccessor buildAccessor(MetadataAccessibleObject accessibleObject, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isEmbedded(accessibleObject, descriptor)) {
            return new EmbeddedAccessor(accessibleObject, this, descriptor);
        }
        if (AnnotationsHelper.isManyToMany(accessibleObject, descriptor)) {
            return new ManyToManyAccessor(accessibleObject, this, descriptor);
        }
        if (AnnotationsHelper.isManyToOne(accessibleObject, descriptor)) {
            return new ManyToOneAccessor(accessibleObject, this, descriptor);
        }
        if (AnnotationsHelper.isOneToMany(accessibleObject, this.getLogger(), descriptor)) {
            return new OneToManyAccessor(accessibleObject, this, descriptor);
        }
        if (AnnotationsHelper.isOneToOne(accessibleObject, this.m_metadataDescriptors, this.getLogger(), descriptor)) {
            return new OneToOneAccessor(accessibleObject, this, descriptor);
        }
        return new AnnotationsAccessor(accessibleObject, this, descriptor);
    }

    protected DatabaseTable buildJoinTable(JoinTable joinTable, MetadataAccessor accessor) {
        if (joinTable != null) {
            DatabaseTable dbJoinTable = this.buildJoinTable(joinTable.name(), joinTable.catalog(), joinTable.schema(), accessor);
            this.processUniqueConstraints(joinTable.uniqueConstraints(), dbJoinTable);
            return dbJoinTable;
        }
        return this.buildDefaultJoinTable(accessor);
    }

    public Collection<Class> getClasses() {
        return this.m_classes;
    }

    @Override
    public AnnotationsLogger getLogger() {
        return (AnnotationsLogger)this.m_logger;
    }

    @Override
    public AnnotationsDescriptor getMetadataDescriptor(Class cls) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)this.m_metadataDescriptors.get(cls);
        if (descriptor == null) {
            ClassDescriptor descriptorOnProject = MetadataHelper.findDescriptor(this.m_session.getProject(), cls);
            if (descriptorOnProject != null) {
                descriptor = new AnnotationsDescriptor(descriptorOnProject, cls);
            } else {
                descriptor = new AnnotationsDescriptor(cls);
                this.m_session.getProject().addDescriptor(descriptor.getDescriptor());
            }
            this.m_metadataDescriptors.put(cls, descriptor);
        }
        return descriptor;
    }

    @Override
    public AnnotationsValidator getValidator() {
        return (AnnotationsValidator)this.m_validator;
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataAccessor accessor, String defaultName, String context) {
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataDescriptor md) {
    }

    @Override
    protected boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping mapping, List joinColumns) {
        return false;
    }

    @Override
    protected boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping mapping, boolean isSource, List relationKeys) {
        return false;
    }

    protected boolean isTransient(AnnotatedElement annotatedElement, int modifier, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(Transient.class, annotatedElement, descriptor)) {
            if (AnnotationsHelper.getDeclaredAnnotationsCount(annotatedElement, descriptor) > 1) {
                this.getValidator().throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        if (Modifier.isTransient(modifier)) {
            if (AnnotationsHelper.getDeclaredAnnotationsCount(annotatedElement, descriptor) > 0) {
                this.getValidator().throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        return false;
    }

    protected boolean isValidPersistenceElement(AnnotatedElement annotatedElement, int modifiers, AnnotationsDescriptor descriptor) {
        return !this.isTransient(annotatedElement, modifiers, descriptor) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    protected boolean isValidPersistenceField(Field field, AnnotationsDescriptor descriptor) {
        return this.isValidPersistenceElement(field, field.getModifiers(), descriptor);
    }

    protected boolean isValidPersistenceMethod(Method method, AnnotationsDescriptor descriptor) {
        String methodName;
        if (this.isValidPersistenceElement(method, method.getModifiers(), descriptor) && MetadataHelper.isValidPersistenceMethodName(methodName = method.getName())) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            Method setMethod = MetadataHelper.getSetMethod(method, descriptor.getJavaClass());
            if (setMethod == null) {
                if (AnnotationsHelper.getDeclaredAnnotationsCount(method, descriptor) > 0) {
                    this.getValidator().throwNoCorrespondingSetterMethodDefined(descriptor.getJavaClass(), method);
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_get_method", descriptor, method);
            } else {
                return true;
            }
        }
        return false;
    }

    protected void processAccessorFields(Class cls, AnnotationsDescriptor descriptor) {
        for (Field field : MetadataHelper.getFields(cls)) {
            if (!this.isValidPersistenceField(field, descriptor)) continue;
            this.processAccessor(this.buildAccessor(new MetadataField(field), descriptor));
        }
    }

    protected void processAccessorMethods(Class cls, AnnotationsDescriptor descriptor) {
        for (Method method : MetadataHelper.getDeclaredMethods(cls)) {
            if (!this.isValidPersistenceMethod(method, descriptor)) continue;
            this.processAccessor(this.buildAccessor(new MetadataMethod(method), descriptor));
        }
    }

    @Override
    protected void processAccessors(Class cls, boolean usePropertyAccess, MetadataDescriptor md) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)md;
        if (usePropertyAccess) {
            this.processAccessorMethods(cls, descriptor);
        } else {
            this.processAccessorFields(cls, descriptor);
        }
        descriptor.setIsProcessed(true);
    }

    @Override
    protected void processJoinTable(ManyToManyMapping mapping, MetadataAccessor accessor) {
        JoinTable joinTable = (JoinTable)AnnotationsHelper.getAnnotation(JoinTable.class, accessor);
        DatabaseTable relationTable = this.buildJoinTable(joinTable, accessor);
        mapping.setRelationTable(relationTable);
        String relationTableName = relationTable.getQualifiedName();
        ArrayList<MetadataJoinColumn> sourceKeys = new ArrayList<MetadataJoinColumn>();
        ArrayList<MetadataJoinColumn> targetKeys = new ArrayList<MetadataJoinColumn>();
        if (joinTable != null) {
            for (JoinColumn joinColumn : joinTable.joinColumns()) {
                sourceKeys.add(this.processJoinColumn(joinColumn, accessor, relationTableName, accessor.getMetadataDescriptor()));
            }
            for (JoinColumn inverseJoinColumn : joinTable.inverseJoinColumns()) {
                targetKeys.add(this.processJoinColumn(inverseJoinColumn, accessor, relationTableName, accessor.getReferenceMetadataDescriptor()));
            }
        }
        this.processJoinTable(mapping, sourceKeys, targetKeys, accessor);
    }

    @Override
    protected void processAssociationOverrides(AggregateObjectMapping mapping, MetadataAccessor accessor) {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)AnnotationsHelper.getAnnotation(AssociationOverrides.class, accessor);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                this.processAssociationOverride(associationOverride2, mapping, accessor);
            }
        }
        if ((associationOverride = (AssociationOverride)AnnotationsHelper.getAnnotation(AssociationOverride.class, accessor)) != null) {
            this.processAssociationOverride(associationOverride, mapping, accessor);
        }
    }

    protected void processAssociationOverride(AssociationOverride associationOverride, AggregateObjectMapping aggregateMapping, MetadataAccessor accessor) {
        String name;
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        MetadataDescriptor aggregateDescriptor = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping mapping = aggregateDescriptor.getMappingForAttributeName(name = associationOverride.name());
        if (mapping == null) {
            // empty if block
        }
        if (mapping.isOneToOneMapping()) {
            int index = 0;
            for (JoinColumn joinColumn : associationOverride.joinColumns()) {
                DatabaseField fkField = (DatabaseField)((OneToOneMapping)mapping).getForeignKeyFields().elementAt(index++);
                aggregateMapping.addFieldNameTranslation(joinColumn.name(), fkField.getName());
            }
        }
    }

    @Override
    protected void processAttributeOverrides(AggregateObjectMapping mapping, MetadataAccessor accessor) {
        AttributeOverride attributeOverride;
        AttributeOverrides attributeOverrides = (AttributeOverrides)AnnotationsHelper.getAnnotation(AttributeOverrides.class, accessor);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                this.processAttributeOverride(mapping, new AnnotationsColumn(attributeOverride2.column(), attributeOverride2.name(), accessor), accessor);
            }
        }
        if ((attributeOverride = (AttributeOverride)AnnotationsHelper.getAnnotation(AttributeOverride.class, accessor)) != null) {
            this.processAttributeOverride(mapping, new AnnotationsColumn(attributeOverride.column(), attributeOverride.name(), accessor), accessor);
        }
    }

    @Override
    protected void processBasic(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        Basic basic = (Basic)AnnotationsHelper.getAnnotation(Basic.class, accessor);
        if (basic != null) {
            if (basic.fetch() == FetchType.LAZY) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_basic_fetch_lazy", accessor);
            }
            mapping.setIsOptional(basic.optional());
        }
    }

    protected void processCallbackMethods(Method[] candidateMethods, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        for (Method method : candidateMethods) {
            this.processPostLoad(method, listener, descriptor);
            this.processPostPersist(method, listener, descriptor);
            this.processPostRemove(method, listener, descriptor);
            this.processPostUpdate(method, listener, descriptor);
            this.processPrePersist(method, listener, descriptor);
            this.processPreRemove(method, listener, descriptor);
            this.processPreUpdate(method, listener, descriptor);
        }
    }

    @Override
    protected void processCascadeType(ForeignReferenceMapping mapping, MetadataAccessor accessor) {
        for (CascadeType cascadeType : (CascadeType[])accessor.getCascadeTypes()) {
            this.setCascadeType(cascadeType.name(), mapping);
        }
        if (accessor.getMetadataDescriptor().isCascadePersistSet().booleanValue() && !mapping.isCascadePersist()) {
            this.setCascadeType("PERSIST", mapping);
        }
    }

    @Override
    protected AnnotationsColumn processColumn(MetadataAccessor accessor) {
        Column column = (Column)AnnotationsHelper.getAnnotation(Column.class, accessor);
        AnnotationsColumn annotationsColumn = new AnnotationsColumn(column, accessor);
        this.processColumnDefaults(annotationsColumn);
        return annotationsColumn;
    }

    protected void processDefaultListeners(AnnotationsDescriptor descriptor) {
        for (MetadataEntityListener defaultListener : descriptor.getDefaultEventListeners()) {
            defaultListener.initializeCallbackMethods(this.m_loader);
            this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForDefaultListener(defaultListener), defaultListener, descriptor);
        }
    }

    protected void processDiscriminatorColumn(AnnotationsDescriptor descriptor) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)AnnotationsHelper.getAnnotation(DiscriminatorColumn.class, descriptor);
        int length = 31;
        String name = "";
        String columnDefinition = "";
        String discriminatorType = "STRING";
        if (discriminatorColumn != null) {
            name = discriminatorColumn.name();
            discriminatorType = discriminatorColumn.discriminatorType().toString();
            columnDefinition = discriminatorColumn.columnDefinition();
            length = discriminatorColumn.length();
        }
        this.processDiscriminatorColumn(name, columnDefinition, length, discriminatorType, descriptor);
    }

    @Override
    protected void processEntityClass(Class cls) {
        AnnotationsDescriptor descriptor = this.getMetadataDescriptor(cls);
        if (descriptor != null && !descriptor.isAggregate() && !descriptor.isProcessed()) {
            Entity entity;
            descriptor.setIgnoreFlags();
            String entityName = "";
            if (!AnnotationsHelper.shouldIgnoreAnnotations(cls, this.m_metadataDescriptors) && (entity = (Entity)AnnotationsHelper.getAnnotation(Entity.class, cls)) != null) {
                entityName = entity.name();
            }
            this.processEntity(entityName, descriptor);
            this.processNamedQueries(descriptor);
            this.processNamedNativeQueries(descriptor);
            this.processSqlResultSetMappings(descriptor);
            this.processTableGenerator(cls, descriptor);
            this.processSequenceGenerator(cls, descriptor);
            this.processTableAnnotation(descriptor);
            this.processIdClass(descriptor);
            this.processMappedSuperclasses(descriptor);
            this.processAccessors(descriptor);
            if (descriptor.isDefaultPrimaryKeySet()) {
                this.adjustPrimaryKeyNameOnExistingFields(descriptor);
            }
            if (descriptor.hasCompositePrimaryKey()) {
                if (descriptor.pkClassWasNotValidated()) {
                    this.getValidator().throwInvalidCompositePKSpecification(cls, descriptor.getPKClassName());
                }
            } else if (!descriptor.hasPrimaryKeyFields() && !descriptor.isInheritanceSubclass()) {
                this.getValidator().throwNoPrimaryKeyAnnotationsFound(cls);
            }
            this.processSecondaryTables(descriptor);
        }
    }

    protected void processEntityEventListener(AnnotationsDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        if (descriptor.hasEntityEventListener()) {
            MetadataEntityListener entityEventListener = descriptor.getEntityEventListener();
            entityEventListener.initializeCallbackMethods(this.m_loader);
        } else {
            AnnotationsEntityClassListener listener = new AnnotationsEntityClassListener(entityClass);
            this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityClass(entityClass), listener, descriptor);
            for (Class mappedSuperclass : descriptor.getMappedSuperclasses()) {
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(mappedSuperclass, entityClass), listener, descriptor);
            }
            if (listener.hasCallbackMethods()) {
                descriptor.setEntityEventListener(listener);
            }
        }
    }

    protected void processEntityListeners(AnnotationsDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        if (descriptor.hasEntityListenerEventListeners()) {
            for (MetadataEntityListener entityListener : descriptor.getEntityListenerEventListeners()) {
                entityListener.initializeCallbackMethods(this.m_loader);
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(entityListener), entityListener, descriptor);
            }
        } else if (AnnotationsHelper.isAnnotationPresent(EntityListeners.class, descriptor)) {
            if (!descriptor.excludeSuperclassListeners()) {
                List<Class> mappedSuperclasses = descriptor.getMappedSuperclasses();
                int mappedSuperclassesSize = mappedSuperclasses.size();
                for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                    Class mappedSuperclass = mappedSuperclasses.get(i);
                    EntityListeners entityListeners = (EntityListeners)AnnotationsHelper.getAnnotation(EntityListeners.class, mappedSuperclass, descriptor);
                    this.processEntityListeners(entityListeners, entityClass, descriptor);
                }
            }
            EntityListeners entityListeners = (EntityListeners)AnnotationsHelper.getAnnotation(EntityListeners.class, descriptor);
            this.processEntityListeners(entityListeners, entityClass, descriptor);
        }
    }

    protected void processEntityListeners(EntityListeners entityListeners, Class entityClass, AnnotationsDescriptor descriptor) {
        if (entityListeners != null) {
            for (Class entityListener : entityListeners.value()) {
                MetadataEntityListener listener = new MetadataEntityListener(entityListener, entityClass);
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener), listener, descriptor);
                descriptor.addEntityListenerEventListener(listener);
            }
        }
    }

    @Override
    protected void processEnumerated(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        boolean isOrdinal = true;
        if (accessor.hasEnumerated()) {
            Enumerated enumerated = (Enumerated)AnnotationsHelper.getAnnotation(Enumerated.class, accessor);
            isOrdinal = enumerated.value() == EnumType.ORDINAL;
        }
        this.processEnumerated(mapping, isOrdinal, accessor);
    }

    protected void processExcludeDefaultListeners(AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(ExcludeDefaultListeners.class, descriptor)) {
            descriptor.setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners(AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(ExcludeSuperclassListeners.class, descriptor)) {
            descriptor.setExcludeSuperclassListeners(true);
        }
    }

    @Override
    protected void processGeneratedValue(Object generatedValue, DatabaseField field, MetadataDescriptor descriptor) {
        this.processGeneratedValue(new AnnotationsGeneratedValue((GeneratedValue)generatedValue), field, descriptor);
    }

    @Override
    protected void processId(DatabaseField field, MetadataAccessor accessor) {
        Id id = (Id)AnnotationsHelper.getAnnotation(Id.class, accessor);
        if (id != null) {
            this.processId(field, AnnotationsHelper.getAnnotation(GeneratedValue.class, accessor), accessor);
        }
    }

    protected void processIdClass(AnnotationsDescriptor descriptor) {
        IdClass idClass = (IdClass)AnnotationsHelper.getAnnotation(IdClass.class, descriptor);
        if (idClass != null) {
            this.processIdClass(idClass.value(), descriptor);
        }
    }

    @Override
    protected void processInheritanceRoot(MetadataDescriptor metadataDescriptor) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)metadataDescriptor;
        Inheritance inheritance = (Inheritance)AnnotationsHelper.getAnnotation(Inheritance.class, descriptor);
        if (inheritance != null || descriptor.isInheritanceRoot()) {
            if (descriptor.ignoreInheritanceAnnotations()) {
                this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_INHERITANCE, descriptor);
            } else {
                String inheritanceStrategy = inheritance == null ? "SINGLE_TABLE" : inheritance.strategy().toString();
                descriptor.setInheritanceStrategy(inheritanceStrategy);
                this.processDiscriminatorColumn(descriptor);
                this.processDiscriminatorValue(descriptor);
            }
        }
    }

    protected MetadataJoinColumn processJoinColumn(JoinColumn joinColumn, MetadataAccessor accessor, String targetTable, MetadataDescriptor sourceDescriptor) {
        return this.processJoinColumn(targetTable, joinColumn.name(), joinColumn.referencedColumnName(), joinColumn.columnDefinition(), joinColumn.table(), joinColumn.unique(), joinColumn.nullable(), joinColumn.insertable(), joinColumn.updatable(), accessor, sourceDescriptor);
    }

    @Override
    protected ArrayList<MetadataJoinColumn> processJoinColumns(MetadataAccessor ma) {
        ArrayList<MetadataJoinColumn> allJoinColumns = new ArrayList<MetadataJoinColumn>();
        AnnotationsAccessor accessor = (AnnotationsAccessor)ma;
        AnnotationsDescriptor descriptor = accessor.getMetadataDescriptor();
        String targetTableName = descriptor.getPrimaryTableName();
        MetadataDescriptor referenceDescriptor = accessor.getReferenceMetadataDescriptor();
        String sourceTableName = referenceDescriptor.getPrimaryTableName();
        if (referenceDescriptor.hasCompositePrimaryKey()) {
            JoinColumn[] joinColumns = new JoinColumn[]{};
            if (descriptor.hasAssociationOverrideFor(accessor)) {
                joinColumns = (JoinColumn[])descriptor.getAssociationOverrideFor(accessor);
            } else {
                JoinColumns jcs = (JoinColumns)AnnotationsHelper.getAnnotation(JoinColumns.class, accessor);
                if (jcs == null) {
                    this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
                } else {
                    joinColumns = jcs.value();
                }
            }
            if (joinColumns.length != referenceDescriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
            }
            for (JoinColumn joinColumn : joinColumns) {
                allJoinColumns.add(this.processJoinColumn(joinColumn, accessor, targetTableName, referenceDescriptor));
            }
        } else {
            JoinColumn joinColumn = descriptor.hasAssociationOverrideFor(accessor) ? ((JoinColumn[])descriptor.getAssociationOverrideFor(accessor))[0] : (JoinColumn)AnnotationsHelper.getAnnotation(JoinColumn.class, accessor);
            if (joinColumn == null) {
                if (accessor.hasJoinColumns()) {
                    this.getValidator().throwExcessiveJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
                }
                this.addJoinColumnDefault(allJoinColumns, sourceTableName, targetTableName, descriptor);
            } else {
                allJoinColumns.add(this.processJoinColumn(joinColumn, accessor, targetTableName, referenceDescriptor));
            }
        }
        return allJoinColumns;
    }

    protected void processNamedNativeQueries(AnnotationsDescriptor descriptor) {
        this.processNamedNativeQueries(descriptor.getJavaClass(), descriptor);
    }

    @Override
    protected void processNamedNativeQueries(Class entityClass, MetadataDescriptor metadataDescriptor) {
        NamedNativeQuery namedNativeQuery;
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)metadataDescriptor;
        NamedNativeQueries namedNativeQueries = (NamedNativeQueries)AnnotationsHelper.getAnnotation(NamedNativeQueries.class, entityClass, descriptor);
        if (namedNativeQueries != null) {
            for (NamedNativeQuery namedNativeQuery2 : namedNativeQueries.value()) {
                descriptor.addNamedNativeQuery(namedNativeQuery2);
            }
            this.m_entitiesWithQueries.add(descriptor);
        }
        if ((namedNativeQuery = (NamedNativeQuery)AnnotationsHelper.getAnnotation(NamedNativeQuery.class, entityClass, descriptor)) != null) {
            descriptor.addNamedNativeQuery(namedNativeQuery);
            this.m_entitiesWithQueries.add(descriptor);
        }
    }

    protected void processNamedNativeQuery(NamedNativeQuery namedNativeQuery, AnnotationsDescriptor descriptor, AbstractSession session) {
        String name = namedNativeQuery.name();
        if (session.getQuery(name) != null) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_QUERY, descriptor, name);
        } else {
            String queryString = namedNativeQuery.query();
            HashMap<String, String> hints = this.processQueryHints(namedNativeQuery.hints(), name);
            Class resultClass = namedNativeQuery.resultClass();
            if (resultClass != Void.TYPE) {
                resultClass = MetadataHelper.getClassForName(resultClass.getName(), this.m_loader);
                session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(resultClass, queryString, hints));
                return;
            }
            String resultSetMapping = namedNativeQuery.resultSetMapping();
            if (!resultSetMapping.equals("")) {
                session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(resultSetMapping, queryString, hints));
                return;
            }
            session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(queryString, hints));
        }
    }

    protected void processNamedQueries(AnnotationsDescriptor descriptor) {
        this.processNamedQueries(descriptor.getJavaClass(), descriptor);
    }

    @Override
    protected void processNamedQueries(Class entityClass, MetadataDescriptor metadataDescriptor) {
        NamedQuery namedQuery;
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)metadataDescriptor;
        NamedQueries namedQueries = (NamedQueries)AnnotationsHelper.getAnnotation(NamedQueries.class, entityClass, descriptor);
        if (namedQueries != null) {
            for (NamedQuery namedQuery2 : namedQueries.value()) {
                descriptor.addNamedQuery(namedQuery2);
            }
            this.m_entitiesWithQueries.add(descriptor);
        }
        if ((namedQuery = (NamedQuery)AnnotationsHelper.getAnnotation(NamedQuery.class, entityClass, descriptor)) != null) {
            descriptor.addNamedQuery(namedQuery);
            this.m_entitiesWithQueries.add(descriptor);
        }
    }

    protected void processNamedQuery(NamedQuery namedQuery, AnnotationsDescriptor descriptor, AbstractSession session) {
        String name = namedQuery.name();
        if (session.getQuery(name) != null) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_QUERY, descriptor, name);
        } else {
            try {
                String queryString = namedQuery.query();
                HashMap<String, String> hints = this.processQueryHints(namedQuery.hints(), name);
                session.addEjbqlPlaceHolderQuery(new EJBQLPlaceHolderQuery(name, queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryAnnotation(descriptor.getJavaClass(), name, exception);
            }
        }
    }

    public AbstractSession processORAnnotations() {
        for (Class cls : this.m_classes) {
            this.processEntityClass(cls);
        }
        this.m_metadataProject.process(this.m_session.getProject().getLogin(), this.m_metadataDescriptors);
        for (AnnotationsDescriptor descriptor : this.m_relatedEntities) {
            this.processRelatedEntity(descriptor);
        }
        Map aliasDescriptors = this.m_session.getProject().getAliasDescriptors();
        if (aliasDescriptors != null) {
            aliasDescriptors.remove("");
        }
        return this.m_session;
    }

    protected void processPostLoad(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostLoad.class, method, descriptor)) {
            listener.setPostBuildMethod(method);
            listener.setPostCloneMethod(method);
            listener.setPostRefreshMethod(method);
        }
    }

    protected void processPostPersist(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostPersist.class, method, descriptor)) {
            listener.setPostInsertMethod(method);
        }
    }

    protected void processPostRemove(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostRemove.class, method, descriptor)) {
            listener.setPostDeleteMethod(method);
        }
    }

    protected void processPostUpdate(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostUpdate.class, method, descriptor)) {
            listener.setPostUpdateMethod(method);
        }
    }

    protected void processPrePersist(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PrePersist.class, method, descriptor)) {
            listener.setPrePersistMethod(method);
        }
    }

    protected void processPreRemove(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PreRemove.class, method, descriptor)) {
            listener.setPreRemoveMethod(method);
        }
    }

    protected void processPreUpdate(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PreUpdate.class, method, descriptor)) {
            listener.setPreUpdateWithChangesMethod(method);
        }
    }

    @Override
    protected ArrayList<MetadataJoinColumn> processPrimaryKeyJoinColumns(Object[] primaryKeyJoinColumns, String sourceTableName, String targetTableName, MetadataDescriptor descriptor) {
        ArrayList<MetadataJoinColumn> metadataJoinColumns = new ArrayList<MetadataJoinColumn>();
        for (PrimaryKeyJoinColumn primaryKeyJoinColumn : (PrimaryKeyJoinColumn[])primaryKeyJoinColumns) {
            metadataJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
        }
        return metadataJoinColumns;
    }

    protected ArrayList<MetadataJoinColumn> processPrimaryKeyJoinColumns(String sourceTableName, String targetTableName, Object element, MetadataDescriptor md) {
        ArrayList<MetadataJoinColumn> allPrimaryKeyJoinColumns = new ArrayList<MetadataJoinColumn>();
        AnnotatedElement annotatedElement = (AnnotatedElement)element;
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)md;
        if (descriptor.hasCompositePrimaryKey()) {
            PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)AnnotationsHelper.getAnnotation(PrimaryKeyJoinColumns.class, annotatedElement, descriptor);
            if (primaryKeyJoinColumns == null || primaryKeyJoinColumns.value().length != descriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(annotatedElement);
            }
            for (PrimaryKeyJoinColumn primaryKeyJoinColumn : primaryKeyJoinColumns.value()) {
                allPrimaryKeyJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
            }
        } else {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = (PrimaryKeyJoinColumn)AnnotationsHelper.getAnnotation(PrimaryKeyJoinColumn.class, annotatedElement, descriptor);
            if (primaryKeyJoinColumn == null) {
                if (descriptor.hasPrimaryKeyJoinColumns()) {
                    this.getValidator().throwExcessivePrimaryKeyJoinColumnsSpecified(annotatedElement);
                }
                this.addJoinColumnDefault(allPrimaryKeyJoinColumns, sourceTableName, targetTableName, descriptor);
            } else {
                allPrimaryKeyJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
            }
        }
        return allPrimaryKeyJoinColumns;
    }

    protected HashMap<String, String> processQueryHints(QueryHint[] queryHints, String queryName) {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (QueryHint queryHint : queryHints) {
            QueryHintsHandler.verify(queryHint.name(), queryHint.value(), queryName, this.m_session);
            hm.put(queryHint.name(), queryHint.value());
        }
        return hm;
    }

    protected void processRelatedEntity(AnnotationsDescriptor descriptor) {
        if (descriptor.isInheritanceSubclass()) {
            this.processInheritanceSubclass(descriptor);
        }
        for (MetadataAccessor accessor : descriptor.getRelationshipAccessors()) {
            this.processRelationshipAccessor(accessor);
        }
    }

    protected void processSecondaryTable(SecondaryTable secondaryTable, AnnotationsDescriptor descriptor) {
        if (descriptor.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_secondary_table", descriptor, secondaryTable.name());
        } else {
            DatabaseTable dbTable = this.processSecondaryTable(secondaryTable.name(), secondaryTable.catalog(), secondaryTable.schema(), secondaryTable.pkJoinColumns(), descriptor);
            this.processUniqueConstraints(secondaryTable.uniqueConstraints(), dbTable);
        }
    }

    protected void processSecondaryTables(AnnotationsDescriptor descriptor) {
        SecondaryTables secondaryTables = (SecondaryTables)AnnotationsHelper.getAnnotation(SecondaryTables.class, descriptor);
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTable : secondaryTables.value()) {
                this.processSecondaryTable(secondaryTable, descriptor);
            }
        } else {
            SecondaryTable secondaryTable = (SecondaryTable)AnnotationsHelper.getAnnotation(SecondaryTable.class, descriptor);
            if (secondaryTable != null) {
                this.processSecondaryTable(secondaryTable, descriptor);
            }
        }
    }

    protected void processSequenceGenerator(AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        SequenceGenerator sequenceGenerator = (SequenceGenerator)AnnotationsHelper.getAnnotation(SequenceGenerator.class, annotatedElement, descriptor);
        if (sequenceGenerator != null) {
            String name = sequenceGenerator.name();
            if (name.equals("SEQ_GEN_TABLE")) {
                this.getValidator().throwSequenceGeneratorUsingAReservedName("SEQ_GEN_TABLE", descriptor.getJavaClassName());
            } else {
                this.processSequenceGenerator(new AnnotationsSequenceGenerator(sequenceGenerator, descriptor.getJavaClassName()));
            }
        }
    }

    @Override
    protected void processSequenceGenerator(MetadataAccessor accessor) {
        this.processSequenceGenerator(accessor.getAnnotatedElement(), accessor.getMetadataDescriptor());
    }

    protected void processSqlResultSetMapping(SqlResultSetMapping sqlResultSetMapping) {
        SQLResultSetMapping mapping = new SQLResultSetMapping(sqlResultSetMapping.name());
        for (javax.persistence.EntityResult entityResult : sqlResultSetMapping.entities()) {
            Class entityClass = entityResult.entityClass();
            EntityResult eResult = new EntityResult(entityClass.getName());
            for (javax.persistence.FieldResult fieldResult : entityResult.fields()) {
                eResult.addFieldResult(new FieldResult(fieldResult.name(), fieldResult.column()));
            }
            eResult.setDiscriminatorColumn(entityResult.discriminatorColumn());
            mapping.addResult(eResult);
        }
        for (Annotation annotation : sqlResultSetMapping.columns()) {
            mapping.addResult(new ColumnResult(annotation.name()));
        }
        this.m_session.getProject().addSQLResultSetMapping(mapping);
    }

    protected void processSqlResultSetMappings(AnnotationsDescriptor descriptor) {
        this.processSqlResultSetMappings(descriptor.getJavaClass(), descriptor);
    }

    @Override
    protected void processSqlResultSetMappings(Class entityClass, MetadataDescriptor descriptor) {
        SqlResultSetMappings sqlResultSetMappings = (SqlResultSetMappings)AnnotationsHelper.getAnnotation(SqlResultSetMappings.class, entityClass, descriptor);
        if (sqlResultSetMappings != null) {
            for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
                this.processSqlResultSetMapping(sqlResultSetMapping);
            }
        } else {
            SqlResultSetMapping sqlResultSetMapping = (SqlResultSetMapping)AnnotationsHelper.getAnnotation(SqlResultSetMapping.class, entityClass, descriptor);
            if (sqlResultSetMapping != null) {
                this.processSqlResultSetMapping(sqlResultSetMapping);
            }
        }
    }

    protected void processTableGenerator(AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        TableGenerator tableGenerator = (TableGenerator)AnnotationsHelper.getAnnotation(TableGenerator.class, annotatedElement, descriptor);
        if (tableGenerator != null) {
            String name = tableGenerator.name();
            if (name.equals("SEQ_GEN_SEQUENCE")) {
                this.getValidator().throwTableGeneratorUsingAReservedName("SEQ_GEN_SEQUENCE", descriptor.getJavaClassName());
            } else {
                this.processTableGenerator(new AnnotationsTableGenerator(tableGenerator, descriptor.getJavaClassName()));
            }
        }
    }

    @Override
    protected void processTableGenerator(MetadataAccessor accessor) {
        this.processTableGenerator(accessor.getAnnotatedElement(), accessor.getMetadataDescriptor());
    }

    public void setClasses(Collection<Class> classes) {
        this.m_classes = classes;
    }
}

